<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\Mail\EnviaFormContato;
use Illuminate\Support\Facades\Validator;

class ContatoController extends Controller
{
    public function store(Request $request)
    {
        $rules = [
            'nome' => 'required',
            'email' => 'required|email',
            'telefone' => ['required', function ($attribute, $value, $fail) {
                $telefone = preg_replace('/\D/', '', $value);
                if (strlen($telefone) !== 10 && strlen($telefone) !== 11) {
                    $fail('O campo Telefone deve conter 10 ou 11 dígitos.');
                }
            }],
            'mensagem' => 'required',
        ];

        $checknews = $request->has('checknews') ? 'SIM' : 'NÃO';

        $messages = [
            'nome.required' => 'Por favor, preencha o campo Nome.',
            'email.required' => 'Por favor, preencha o campo Email.',
            'email.email' => 'Por favor, insira um endereço de email válido.',
            'telefone.required' => 'Por favor, preencha o campo Telefone.',
            'mensagem.required' => 'Por favor, preencha o campo Mensagem.',
        ];

        $validator = Validator::make($request->all(), $rules, $messages);

        if ($validator->fails()) {
            return response()->json(['status' => 'error', 'message' => $validator->errors()->first()]);
        }

        $sent = Mail::to('comercial@okea.com.br')->send(new EnviaFormContato([
            'fromName' => $request->input('nome'),
            'fromEmail' => $request->input('email'),
            'telefone' => $request->input('telefone'),
            'message' => $request->input('mensagem'),
        ]));

        return response()->json(['status' => 'success', 'message' => 'E-mail enviado com sucesso!']);
    }
}
