<?php

namespace App\Http\Controllers;

use App\Models\News;
use Illuminate\Http\Request;
use ProtoneMedia\Splade\Facades\SEO;

class NovidadesController extends Controller
{
    public function index()
    {
        $posts = News::with('category')->latest()->simplePaginate(9);
        return view('news', compact('posts'));
    }

    public function show($slug)
    {
        $post = News::where('slug', $slug)->firstOrFail();
        $latestPosts = News::latest()->take(3)->get();

        return view('news-show', compact('post', 'latestPosts'));
    }
}
