<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\App;

class LanguageMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Verificar se já foi definido um idioma na sessão
        $language = session('language');

        // Se não houver idioma definido na sessão, use o idioma padrão
        if (!$language) {
            $language = config('app.locale');
            session(['language' => $language]);
        }

        // Definir o idioma no aplicativo
        app()->setLocale($language);

        return $next($request);
    }
}

