<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class NewsStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'capa' => 'required|image|mimes:jpeg,jpg,png,webp|max:500|dimensions:min_width=1600,min_height=500',
            'title' => 'required|max:255|min:5',
            'categories_id' => 'required|exists:categories,id',
            'description' => 'required',
        ];
    }
}
