<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class News extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'slug',
        'description',
        'categories_id',
        'capa',
    ];

    public function category(): BelongsTo
    {
        return $this->belongsTo(Categories::class, 'categories_id');
    }

}
