<?php
	require 'framework/configs.php';
	require 'wp/wp-load.php';

	if (!empty($_GET['id'])) {
		$id = $Utils->clearInjection($_GET['id']);
		
		$args = array(
			'name' => $id,
			'numberposts' => 1
		);
		$post = get_posts($args);
		
		$smarty->assign('post', $post[0]);

		$args2 = array(
			'post__not_in' => array($post[0]->ID),
			'posts_per_page' => 2
		);

		$wp_query2 = new WP_Query( $args2 );

		$postsAr = array();
		
		while ($wp_query2->have_posts()) {
			$wp_query2->the_post();

			$post = array();
			$post['id'] = $wp_query2->post->ID;
			$post['slug'] = $wp_query2->post->post_name;
			$post['title'] = $wp_query2->post->post_title;
			$post['content'] = $wp_query2->post->post_content;
			$post['date'] = $wp_query2->post->post_date;
			$post['thumb'] = wp_get_attachment_image_src ( get_post_thumbnail_id( $wp_query2->post->ID ), 'medium' );

			$postsAr[] = $post;
		}

		if (count($postsAr) > 0) {
			$smarty->assign('maisPosts', $postsAr);
		}
	} else {
		$paged = $Utils->clearInjection($_GET['page']);

		$args = array(
			'posts_per_page' => -1
		);

		$wp_query = new WP_Query( $args );

		$postsAr = array();
		
		while ($wp_query->have_posts()) {
			$wp_query->the_post();

			$post = array();
			$post['id'] = $wp_query->post->ID;
			$post['slug'] = $wp_query->post->post_name;
			$post['title'] = $wp_query->post->post_title;
			$post['content'] = $wp_query->post->post_content;
			$post['date'] = $wp_query->post->post_date;
			$post['thumb'] = wp_get_attachment_image_src ( get_post_thumbnail_id( $wp_query->post->ID ), 'medium' );

			$postsAr[] = $post;
		}

		if (count($postsAr) > 0) {
			$paginatedData = $Utils->arrayPagination($postsAr, 8, $paged, 'blog/');

			$smarty->assign('posts', $paginatedData['data']);
			$smarty->assign('paginador', $paginatedData['pagination']);
		}
	}
	
	$smarty->display('blog.tpl');