<?php
class Users
{
	const TABELA = "users";
	
	public static function listar($filtro)
	{
		return Qi_Db::select(self::TABELA, $filtro);
	}

	public static function get($id)
	{
		return Qi_Db::get(self::TABELA, $id);
	}

	public static function salvar($dados)
	{
		return Qi_Db::salvar(self::TABELA, $dados);
	}

	public static function excluir($ids)
	{
		if (is_array($ids)):
			$ids = implode(", ", $ids);
			$filtro = "id IN ($ids)";
		else:
			$filtro = array("id" => $ids);
		endif;
		return Qi_Db::delete(self::TABELA, $filtro);
	}
}

class Apresentacoes
{
	const TABELA = "apresentacoes";
	
	public static function listar($filtro)
	{
		return Qi_Db::select(self::TABELA, $filtro);
	}

	public static function get($id)
	{
		return Qi_Db::get(self::TABELA, $id);
	}

	public static function salvar($dados)
	{
		return Qi_Db::salvar(self::TABELA, $dados);
	}

	public static function excluir($ids)
	{
		if (is_array($ids)):
			$ids = implode(", ", $ids);
			$filtro = "id IN ($ids)";
		else:
			$filtro = array("id" => $ids);
		endif;
		return Qi_Db::delete(self::TABELA, $filtro);
	}
}

class Contatos
{
	const TABELA = "contatos";
	
	public static function listar($filtro)
	{
		return Qi_Db::select(self::TABELA, $filtro);
	}

	public static function get($id)
	{
		return Qi_Db::get(self::TABELA, $id);
	}

	public static function salvar($dados)
	{
		return Qi_Db::salvar(self::TABELA, $dados);
	}

	public static function excluir($ids)
	{
		if (is_array($ids)):
			$ids = implode(", ", $ids);
			$filtro = "id IN ($ids)";
		else:
			$filtro = array("id" => $ids);
		endif;
		return Qi_Db::delete(self::TABELA, $filtro);
	}
}

?>