<?php
require 'Pagination.class.php';

class Utils {

	private static $instance;
	private static $algo = '$2a';
	private static $cost = '$10';

	private function __construct() { }

	public function __clone() {
		trigger_error('Clonar o Objeto gera Erro: E_USER_ERROR', E_USER_ERROR);
	}

	public static function getInstance() {
		if(!isset(Utils::$instance)) {
			self::$instance = new Utils();
		}
		return self::$instance;
	}
    
	public function uniqueSalt() {
		return substr(sha1(mt_rand()),0,22);
	}
	
	public function createHash($password) {
		return crypt($password,
					self::$algo .
					self::$cost .
					'$' . $this->uniqueSalt());
	}
	
	public function checkPassword($hash, $password) {
		$full_salt = substr($hash, 0, 29);
		$new_hash = crypt($password, $full_salt);
		return ($hash == $new_hash)?true:false;
	}

	public function clearInjection($str) {
		if (!is_numeric($str)) {
			$str = get_magic_quotes_gpc() ? stripslashes($str) : $str;
			$str = function_exists('mysql_real_escape_string') ? mysql_real_escape_string($str) : mysql_escape_string($str);
		}
		return $str;
	}

	public function gerarToken($tamanho = 5, $numeros = true, $simbolos = false) {
        $lmai = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $num = '1234567890';
        $simb = '!@#$%*-';
        $retorno = 'VGE';
        $caracteres = '';

        $caracteres .= $lmai;
        if ($numeros)
            $caracteres .= $num;
        if ($simbolos)
            $caracteres .= $simb;

        $len = strlen($caracteres);
        for ($n = 1; $n <= $tamanho; $n++) {
            $rand = mt_rand(1, $len);
            $retorno .= $caracteres[$rand - 1];
        }
        return $retorno;
    }

	public function dataDMAH($data) {
		if ($data == 0 || $data == null) {
			return null;
		} else {
			return date("d/m/Y H", strtotime($data));
		}
	}
	
	public function dataDMAHM($data) {
		if ($data == 0 || $data == null) {
			return null;
		} else {
			return date("d/m/Y H:i", strtotime($data));
		}
	}
	
	public function dataDMAHMS($data) {
		if ($data == 0 || $data == null) {
			return null;
		} else {
			return date("d/m/Y H:i:s", strtotime($data));
		}
	}

	public function dataDMA($data) {
		if ($data == 0 || $data == null) {
			return null;
		} else {
			return date("d/m/Y", strtotime($data));
		}
	}

	public function dataYMD($data) {
		if ($data == 0 || $data == null) {
			return null;
		} else {
			return implode('-', array_reverse(explode('/',$data)));
		}
	}

	public function dataDM($data) {
		if ($data == 0 || $data == null) {
			return null;
		} else {
			return date("d/m", strtotime($data));
		}
	}
	
	public function dataHM($data) {
		if ($data == 0 || $data == null) {
			return null;
		} else {
			return date("H:i", strtotime($data));
		}
	}
	
	public function dataHMS($data) {
		if ($data == 0 || $data == null) {
			return null;
		} else {
			return date("H:i:s", strtotime($data));
		}
	}

	public function formataValor($valor) {
		if ($valor == 0 || $valor == null) {
			return "R$ 0,00";
		} else {
			return "R$ ".number_format($valor,2,',','.');
		}
	}

	public function formataValorSimbol($valor) {
		if ($valor == 0 || $valor == null) {
			return "0,00";
		} else {
			return number_format($valor,2,',','.');
		}
	}

	public function formataValorToUs($valor) {
		if ($valor == 0 || $valor == null) {
			return "0.00";
		} else {
			$valor = str_replace(".", "", $valor);
			$valor = str_replace(",", ".", $valor);
			return $valor;
		}
	}

	public function DiaSemana($data) {
		$rs = strftime('%w',strtotime($data));
		switch($rs) {
			case "0": $s = "Domingo"; break;
			case "1": $s = "Segunda-feira"; break;
			case "2": $s = "Terça-feira"; break;
			case "3": $s = "Quarta-feira"; break;
			case "4": $s = "Quinta-feira"; break;
			case "5": $s = "Sexta-feira"; break;
			case "6": $s = "Sábado"; break;
		}
		return $s;
	}

	public function escreveStatusBL($status) {
		switch ($status) {
			case 1:
				return "Bloqueado";
				break;
			case 2:
				return "Liberado";
				break;
		}
	}

	public function escreveStatusAI($status) {
		switch ($status) {
			case "true":
				return "Ativo";
				break;
			case "false":
				return "Inativo";
				break;
		}
	}

	public function escreveStatusSN($status) {
		switch ($status) {
			case "true":
				return "Sim";
				break;
			case "false":
				return "Não";
				break;
		}
	}
	
	public function escreveStatusSN2($status) {
		switch ($status) {
			case "S":
				return "Sim";
				break;
			case "N":
				return "Não";
				break;
		}
	}

	public function Mes($mes) {
		switch ($mes) {
			case 1:
				return "Janeiro";
				break;
			case 2:
				return "Fevereiro";
				break;
			case 3:
				return "Março";
				break;
			case 4:
				return "Abril";
				break;
			case 5:
				return "Maio";
				break;
			case 6:
				return "Junho";
				break;
			case 7:
				return "Julho";
				break;
			case 8:
				return "Agosto";
				break;
			case 9:
				return "Setembro";
				break;
			case 10:
				return "Outubro";
				break;
			case 11:
				return "Novembro";
				break;
			case 12:
				return "Dezembro";
				break;
		}
	}

	public function escreveTipoPessoa($posicao) {
		switch($posicao) {
			case "F": $posicao = "Física"; break;
			case "J": $posicao = "Jurídica"; break;
		}
		return $posicao;
	}

	public function escreveSexoMF($posicao) {
		switch($posicao) {
			case "M": $posicao = "Masculino"; break;
			case "F": $posicao = "Feminino"; break;
		}
		return $posicao;
	}

	public function removeAcento($texto) {
		$array1 = array("á", "à", "â", "ã", "ä", "é", "è", "ê", "ë", "í", "ì", "î", "ï", "ó", "ò", "ô", "õ", "ö", "ú", "ù", "û", "ü", "ç", "Á", "À", "Â", "Ã", "Ä"
		, "É", "È", "Ê", "Ë", "Í", "Ì", "Î", "Ï", "Ó", "Ò", "Ô", "Õ", "Ö", "Ú", "Ù", "Û", "Ü", "Ç" );
		$array2 = array("a", "a", "a", "a", "a", "e", "e", "e", "e", "i", "i", "i", "i", "o", "o", "o", "o", "o", "u", "u", "u", "u", "c", "A", "A", "A", "A", "A"
		,"E", "E", "E", "E", "I", "I", "I", "I", "O", "O", "O", "O", "O", "U", "U", "U", "U", "C" );
		return str_replace( $array1, $array2, $texto );
	}

	public function removeAcentoEspaco($texto) {
		$array1 = array("á", "à", "â", "ã", "ä", "é", "è", "ê", "ë", "í", "ì", "î", "ï", "ó", "ò", "ô", "õ", "ö", "ú", "ù", "û", "ü", "ç", "Á", "À", "Â", "Ã", "Ä", "É", "È", "Ê", "Ë", "Í", "Ì", "Î", "Ï", "Ó", "Ò", "Ô", "Õ", "Ö", "Ú", "Ù", "Û", "Ü", "Ç"," " );
		$array2 = array("a", "a", "a", "a", "a", "e", "e", "e", "e", "i", "i", "i", "i", "o", "o", "o", "o", "o", "u", "u", "u", "u", "c", "A", "A", "A", "A", "A","E", "E", "E", "E", "I", "I", "I", "I", "O", "O", "O", "O", "O", "U", "U", "U", "U", "C", "-" );
		return str_replace( $array1, $array2, $texto );
	}

	public function statusUsuario($rs) {
		switch($rs) {
			case "LIB": $s = "Liberado"; break;
			case "AGU": $s = "Aguardando Liberção"; break;
			case "BLK": $s = "Bloqueado"; break;
		}
		return $s;
	}

	public function statusCurriculo($rs) {
		switch($rs) {
			case "LIDO": $s = "Lido"; break;
			case "NLIDO": $s = "Não Lido"; break;
			case "REC": $s = "Recusado"; break;
		}
		return $s;
	}

public function escreveEstadoCivil($rs) {
		switch($rs) {
			case "solteiro": $s = "Solteiro"; break;
			case "casado": $s = "Casado"; break;
			case "desquitado": $s = "Desquitado"; break;
			case "divorciado": $s = "Divorciado"; break;
		}
		return @$s;
	}

	public function escreveGrauInstrucao($rs) {
		switch($rs) {
			case "ate4": $s = "Até 4ª série incompleta do Ensino Fundamental"; break;
			case "da5a8": $s = "De 5ª a 8ª série completa do Ensino Fundamental"; break;
			case "fundamentalcompleto": $s = "Ensino Fundamental Completo"; break;
			case "medioincompleto": $s = "Ensino Médio Incompleto"; break;
			case "mediocompleto": $s = "Ensino Médio Completo"; break;
			case "superiorincompleto": $s = "Superior Incompleto"; break;
			case "superiorcompleto": $s = "Superior Completo"; break;
			case "posgraduacao": $s = "Pós-graduação"; break;
			case "doutorado": $s = "Doutorado"; break;
			case "mestrado": $s = "Mestrado"; break;
			case "phd": $s = "Phd"; break;
			case "analfabeto": $s = "Analfabeto"; break;
			case "outro": $s = "Outro"; break;
		}
		return @$s;
	}

	public function escreveDeficiencia($rs) {
		switch($rs) {
			case "fisica": $s = "Física"; break;
			case "mental": $s = "Mental"; break;
			case "fala": $s = "Fala"; break;
			case "auditiva": $s = "Auditiva"; break;
			case "visual": $s = "Visual"; break;
			case "outra": $s = "Outra"; break;
		}
		return @$s;
	}

	public function escreveNivelIdioma($rs) {
		switch($rs) {
			case "basico": $s = "Básico"; break;
			case "intermediario": $s = "Intermediário"; break;
			case "avancado": $s = "Avançado"; break;
			case "fluente": $s = "Fluente"; break;
		}
		return @$s;
	}
	
	public function escreveCandidato($rs) {
		switch($rs) {
			case "1": $s = "Estagiário"; break;
			case "2": $s = "Efetivo"; break;
		}
		return $s;
	}
	
	public function escreveAreaInteresse($rs) {
		switch($rs) {
			case "1": $s = "Administrativo"; break;
			case "2": $s = "Analise de Sistemas"; break;
			case "3": $s = "Desenvolvimento"; break;
			case "4": $s = "Financeiro"; break;
			case "5": $s = "Suporte Interno"; break;
			case "6": $s = "Suporte Externo"; break;
			case "7": $s = "Vendas"; break;
			case "8": $s = "Outros"; break;
		}
		return @$s;
	}

	public function checkEmail($email) {
        if (!ereg("^[^@]{1,64}@[^@]{1,255}$", $email)) {
            return false;
        }
        
        $email_array = explode("@", $email);
        $local_array = explode(".", $email_array[0]);
        for ($i = 0; $i < sizeof($local_array); $i++) {
            if
            (!ereg("^(([A-Za-z0-9!#$%&'*+/=?^_`{|}~-][A-Za-z0-9!#$%&'*+/=?^_`{|}~\.-]{0,63})|(\"[^(\\|\")]{0,62}\"))$", $local_array[$i])) {
                return false;
            }
        }
        
        if (!ereg("^\[?[0-9\.]+\]?$", $email_array[1])) {
            $domain_array = explode(".", $email_array[1]);
            if (sizeof($domain_array) < 2) {
                return false; // Not enough parts to domain
            }
            for ($i = 0; $i < sizeof($domain_array); $i++) {
                if
                (!ereg("^(([A-Za-z0-9][A-Za-z0-9-]{0,61}[A-Za-z0-9])|([A-Za-z0-9]+))$", $domain_array[$i])) {
                    return false;
                }
            }
        }
        return true;
    }

    public function validaCnpj($cnpj) {
    	$cnpj = preg_replace('/[^0-9]/', '', (string) $cnpj);
		
		if (strlen($cnpj) != 14)
			return false;
		
		for ($i = 0, $j = 5, $soma = 0; $i < 12; $i++)
		{
			$soma += $cnpj{$i} * $j;
			$j = ($j == 2) ? 9 : $j - 1;
		}
		$resto = $soma % 11;
		if ($cnpj{12} != ($resto < 2 ? 0 : 11 - $resto))
			return false;
		
		for ($i = 0, $j = 6, $soma = 0; $i < 13; $i++)
		{
			$soma += $cnpj{$i} * $j;
			$j = ($j == 2) ? 9 : $j - 1;
		}
		$resto = $soma % 11;
		
		return $cnpj{13} == ($resto < 2 ? 0 : 11 - $resto);
    }

	public function validaCpf($cpf) {
		$cpf = str_replace(".", "", $cpf);
		$cpf = str_replace("-", "", $cpf);
		
		if(!is_numeric($cpf)) {
			$status = false;
		} else {
			if( ($cpf == '11111111111') || ($cpf == '22222222222') ||
			($cpf == '33333333333') || ($cpf == '44444444444') ||
			($cpf == '55555555555') || ($cpf == '66666666666') ||
			($cpf == '77777777777') || ($cpf == '88888888888') ||
			($cpf == '99999999999') || ($cpf == '00000000000') ) {
				$status = false;
			} else {
				$dv_informado = substr($cpf, 9,2);

				for($i=0; $i<=8; $i++) {
					$digito[$i] = substr($cpf, $i,1);
				}

				$posicao = 10;
				$soma = 0;

				for($i=0; $i<=8; $i++) {
					$soma = $soma + $digito[$i] * $posicao;
					$posicao = $posicao - 1;
				}

				$digito[9] = $soma % 11;

				if($digito[9] < 2) {
					$digito[9] = 0;
				} else {
					$digito[9] = 11 - $digito[9];
				}

				$posicao = 11;
				$soma = 0;

				for ($i=0; $i<=9; $i++) {
					$soma = $soma + $digito[$i] * $posicao;
					$posicao = $posicao - 1;
				}

				$digito[10] = $soma % 11;

				if ($digito[10] < 2) {
					$digito[10] = 0;
				} else {
					$digito[10] = 11 - $digito[10];
				}

				//VERIFICA SE O DV CALCULADO É IGUAL AO INFORMADO
				$dv = $digito[9] * 10 + $digito[10];
				if ($dv != $dv_informado) {
					$status = false;
				} else {
					$status = true;
				}
			}
		}
		return $status;
	}
	
	public function exportarNewsCsv($sql, $filename = 'newsletter.csv') {
		$csv_terminated = "\n";
		$csv_separator = ";";
		$csv_enclosed = '"';
		$csv_escaped = "\\";
		$sql_query = $sql;
		$result = mysql_query($sql_query);
		$fields_cnt = mysql_num_fields($result);
		$schema_insert = '';
		for ($i = 0; $i < $fields_cnt; $i++) {
			$l = $csv_enclosed . str_replace($csv_enclosed, $csv_escaped . $csv_enclosed,
			stripslashes(mysql_field_name($result, $i))) . $csv_enclosed;
			$schema_insert .= $l;
			$schema_insert .= $csv_separator;
		}
		$out = trim(substr($schema_insert, 0, -1));
		$out .= $csv_terminated;
		 
		while ($row = mysql_fetch_array($result)) {
			mysql_query("UPDATE newsletter SET exportado = 'S' WHERE email = '{$row['email']}'");
			$schema_insert = '';
			for ($j = 0; $j < $fields_cnt; $j++) {
				if ($row[$j] == '0' || $row[$j] != '') {
					if ($csv_enclosed == '') {
						$schema_insert .= $row[$j];
					} else {
						$schema_insert .= $csv_enclosed .
						str_replace($csv_enclosed, $csv_escaped . $csv_enclosed, $row[$j]) . $csv_enclosed;
					}
				} else {
					$schema_insert .= '';
				}
				if ($j < $fields_cnt - 1) {
					$schema_insert .= $csv_separator;
				}
			} // end for
			$out .= $schema_insert;
			$out .= $csv_terminated;
		} // end while
		header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
		header("Content-Length: " . strlen($out));

		//header("Content-type: text/x-csv");
		//header("Content-type: text/csv");
		header("Content-type: application/csv");
		header("Content-Disposition: attachment; filename=$filename");
		echo $out;
		exit;
	}

	public function getCategories($query) {
		$result = mysql_query($query);
		$data = array();
		while ($row = mysql_fetch_assoc($result)) {
		    $data[$row['id']] = $row;
		}


		/******************* ARRAY LIST GENERATOR *******************/
		$digits = 2;
		$menu = array();
		$added = 1;
		while ($added) {
		    $added = 0;
		    foreach ($data as $k => &$v) {
		        if (!isset($v['key'])) {
		            if (!$v['parent']) {
		                $key = sprintf("%0{$digits}d", ++$added);
		                $menu[$key] = $v;
		                $v['key'] = $key;
		                $menu[$key]['parentKey'] = 0;
		                $menu[$key]['level'] = 1;
		            } else {
		                if (isset($data[$v['parent']]['key']) && isset($menu[$data[$v['parent']]['key']])) {
		                    if (isset($menu[$data[$v['parent']]['key']]['children'])) {
		                        $key = $data[$v['parent']]['key'] . sprintf("%0{$digits}d", count($menu[$data[$v['parent']]['key']]['children']) + 1);
		                        $menu[$data[$v['parent']]['key']]['children'][] = $key;
		                    } else {
		                        $key = $data[$v['parent']]['key'] . sprintf("%0{$digits}d", 1);
		                        $menu[$data[$v['parent']]['key']]['children'][] = $key;
		                    }
		                    $menu[$key] = $v;
		                    $menu[$key]['parentKey'] = $data[$v['parent']]['key'];
		                    $menu[$key]['level'] = $menu[$menu[$key]['parentKey']]['level'] + 1;
		                    $v['key'] = $key;
		                    $added++;
		                }
		            }
		        }
		    }
		}

		ksort($menu, SORT_STRING);

		/******************* UL LI GENERATOR *******************/
		$li = array();
		$ul = array();
		$levelLL = 0;
		$html = "<ul class=\"categorias\">";
		$ul[1] = 1;

		foreach ($menu as $k => &$v) {
		    if ($v['level'] < $levelLL) {
		        for ($i = $levelLL; $i > $v['level'] - 1; $i--) {
		            if (isset($li[$i])) {
		                $html .= "</li>";
		                unset($li[$i]);
		            }
		            
		            if (isset($ul[$i]) && $i > $v['level']) {
		                $html .= "</ul>";
		                unset($ul[$i]);
		            }
		        }
		    } elseif ($v['level'] == $levelLL) {
		        $html .= "</li>";
		    }
		    
		    if($v['level'] == 2) {
		    	if($this->getCategoryHasChild('categorias', $v['id']) === false) {
		    		$html .= "<li class=\"bg-white\">";
		    	} else {
		    		$html .= "<li>";
		    	}
		    } else {
			    $html .= "<li>";
			}

		    $li[$v['level']] = 1;
		    $html .= "<a href=\"/solucoes-em-energia/cat/" . $v['id'] . "/\">" . $v['nome'] . "</a>";

		    if (isset($v['children'])) {
		        $html .= "<ul>";
		        $ul[$v['level'] + 1] = 1;
		    }
		    $levelLL = $v['level'];
		}

		if (0 < $levelLL) {
		    for ($i = $levelLL; $i > -1; $i--) {
		        if (isset($li[$i])) {
		            $html .= "</li>";
		            unset($li[$i]);
		        }

		        if (isset($ul[$i]) && $i > 0) {
		            $html .= "</ul>";
		            unset($ul[$i]);
		        }
		    }
		}

		return $html;
    }

    public function getBreadcrumbs($table, $categoria_id) {
    	$categoria = Qi_Db::query("SELECT * FROM " . $table . " WHERE id = '{$categoria_id}'");
		$parent = $categoria['parent'];
		$breadcrumbs = array();

		if($categoria['parent'] != 0) {
			$breadcrumbs[] = " \ " . $categoria['nome'];
		} else {
			$breadcrumbs[] = $categoria['nome'];
		}

		while($parent != 0) {
		    $query = Qi_Db::query("SELECT * FROM " . $table . " WHERE id = '{$parent}'");

		    if($query['parent'] != 0) {
				$breadcrumbs[] = " \ " . $query['nome'];
			} else {
				$breadcrumbs[] = $query['nome'];
			}

		    $parent = $query['parent'];
		}
		krsort($breadcrumbs);

		return $breadcrumbs;
    }

    public function getCategoryLevel($table, $categoria_id) {
    	$categoria = Qi_Db::query("SELECT * FROM " . $table . " WHERE id = '{$categoria_id}'");
		$parent = $categoria['parent'];
		$level = 1;

		while($parent != 0) {
		    $query = Qi_Db::query("SELECT * FROM " . $table . " WHERE id = '{$parent}'");

		    $level += 1;

		    $parent = $query['parent'];
		}

		return $level;
    }

    public function getCategoryHasChild($table, $categoria_id) {
    	$categoria = Qi_Db::query("SELECT * FROM " . $table . " WHERE parent = '{$categoria_id}'");
		
		if(count($categoria) > 0) {
			return true;
		}

		return false;
	}
	
	public function arrayPagination($arData, $limit, $currentPage, $target) {
		$page = ! empty( $currentPage ) ? (int) $currentPage : 1;
		$total = count( $arData );
		$limit = ! empty( $limit ) ? (int) $limit : 1;
		$totalPages = ceil( $total / $limit );
		$page = max($page, 1);
		$page = min($page, $totalPages);
		$offset = ($page - 1) * $limit;
		if( $offset < 0 ) $offset = 0;

		$pagination = new Pagination();
		$pagination->setCurrent($page);
		$pagination->setTotal($total);
		$pagination->setRPP($limit);
		$pagination->setTarget($target);
		
		$pagerContainer = $pagination->parse();

		$arData = array_slice( $arData, $offset, $limit );

		return array(
			'data' => $arData,
			'pagination' => $pagerContainer
		);
	}
}
?>