<?

class Qi_Array
{
	/**
	* Ordena um array pelas chaves igual ksort, mas no diferencia maisculo de minsculo
	* Como todas as funes de ordenao, o parmetro tambm  passado por referncia.
	* Alm de modificar o array, tambm o retorna.
	*/
	public static function kcasesort(array &$array)
	{
		uksort($array, "strcasecmp");
		return $array;
	}

	/**
	* Conta quantos elementos um array tem de forma recursiva.
	* A diferena para count($array, COUNT_RECURSIVE)  que esta conta apenas as folhas, 
	* enquanto count conta folhas e ns.
	*/
	public static function cont($array)
	{
		$count = 0;
		foreach($array as $v):
			if (is_array($v) || $v instanceof Traversable) 
				$count += self::cont($v);
			else $count++;
		endforeach;
		return $count;
	}

	/**
	* Retorna a diferena do ponto de vista de ser o contrrio da interseco.
	* Ela retorna os elementos que existem em um array, mas no no outro e vice-versa.
	* Diferente da funo array_diff do PHP, que
	* retorna os elementos que existem no primeiro array, mas no no segundo.
	* Portanto ela depende da ordem de execuo.
	* Na verdade array_diff deveria se chamar array_sub, pois subtrai do primeiro array, 
	* os elementos encontrados iguais no segundo array.
	*/
	public static function diff(array $a1, array $a2, $separar_por_array = false)
	{
		$interseccao = array_intersect($a1, $a2);
		$d1 = array_diff($a1, $interseccao);
		$d2 = array_diff($a2, $interseccao);
		return $separar_por_array ? array($d1, $d2) : array_merge($d1, $d2);
	}
/*  @TODO: ninguem est utilizando
	public static function diff_key(array $a1, array $a2, $separar_por_array = false)
	{
		$interseccao = array_intersect_key($a1, $a2);
		$d1 = array_diff_key($a1, $interseccao);
		$d2 = array_diff_key($a2, $interseccao);
		return $separar_por_array ? array($d1, $d2) : array_merge($d1, $d2);
	}
*/
	/**
	* Faz exatamente o mesmo que natcasesort, mas os ndices so resetados de 0..n
	*/
	public static function natcasesort(array &$array)
	{
		natcasesort($array);
		return $array = array_values($array);
	}
}

?>