<?

/**
 * Mover os renders para classes externas
 * Implementar enum, SET, textarea, data, datetime e campos numricos
 * Implementar campo que aceita apenas numero. Colocar uma classe e controlar externamente por javascript (tentar por flash)
 * Separar esta tabela da renderizao dos campos
**/

class Qi_Db_Def_Coluna
{
	public $nome = "";
	public $rotulo = "";
	public $padrao = null;
	public $codificacao = "";
	public $tipo = null;
	public $tamanho = 0;
	public $eh_nulo = false;
	public $eh_unico = false;
	public $eh_chave = false;
	public $eh_auto_increment = false;

	const BOOL = "BOOL";

	/**
	* $linha  um array no formato retornado por: SHOW FULL COLUMNS FROM tabela
	* extrai os dados para atributos da classe
	*/
	public function __construct($linha)
	{
		$this->nome = $linha["Field"];
		$this->rotulo = Qi_Util::rotulo($this->nome);
		$this->padrao = $linha["Default"];
		$this->eh_nulo = $linha["Null"] != "NO";
		$this->codificacao = $linha["Collation"];
		$this->eh_chave = $linha["Key"] == "PRI";
		$this->eh_unico = $linha["Key"] == "UNI";
		$this->_parse_tipo_tamanho($linha["Type"]);
		$this->eh_auto_increment = strpos(trim(strtolower($linha["Extra"])), "auto_increment") !== false;
	}

	public function gerar_html($valor = null)
	{
		$valor = $valor === null ? $this->padrao : $valor;
		if ($this->eh_booleano()) return $this->_gerar_check_box($valor);
		if ($this->eh_texto_longo()) return $this->_gerar_textarea($valor);
		if ($this->eh_enum()) return $this->_gerar_radios($valor);
		return $this->_gerar_input($valor);
	}

	public function eh_booleano()
	{
		return $this->tipo == self::BOOL;
	}

	public function eh_texto_longo()
	{
		return $this->tipo == "TEXT";
	}

	public function eh_enum()
	{
		return $this->tipo == "ENUM";
	}

	/**
	* Gera um grupo de rdios com label separados por <br />,
	* j com a tabulao correta. Utiliza _gerar_radio() para cada opo.
	*/
	private function _gerar_radios($valor = null)
	{
		$radios = array();
		foreach($this->tamanho as $opcao):
			$radios[] = $this->_gerar_radio($opcao, $valor);
		endforeach;
		$radios = implode("\t\t\t<br />", $radios);
		return $this->_gerar_tr($radios);
	}

	/**
	* Gera apenas 1 nico radio, usado para criar um grupo em _gerar_radios()
	*/
	private function _gerar_radio($opcao, $valor = null)
	{
		$nome = Qi_Html::h($this->nome);
		$id = Qi_Util::id("{$nome}_{$opcao}");
		$checked = Qi_Html::checked($valor, $opcao);
		$opcao = htmlspecialchars($opcao);
		$radio = <<<INPUT

			<label for="$id">
				<input class="radio" type="radio" id="$id" name="$nome" value="$opcao"$checked /> $opcao
			</label>

INPUT;
		return $radio;
	}

	private function _gerar_check_box($valor = null)
	{
		$nome = Qi_Html::h($this->nome);
		$checked = Qi_Html::checked($valor);
		$input = <<<INPUT

			<input  type="hidden" id="hidden_$nome" name="$nome" value="0" />
			<input class="checkbox" type="checkbox" id="$nome" name="$nome" value="1"$checked />

INPUT;
		return $this->_gerar_tr($input);
	}

	private function _gerar_input($valor = null)
	{
		$nome = Qi_Html::h($this->nome);
		$valor = Qi_Html::h($valor);
		$tamanho = Qi_Html::h($this->tamanho);
		$input = <<<INPUT
<input class="text" type="text" id="$nome" maxlength="$tamanho" name="$nome" value="$valor" />
INPUT;
		return $this->_gerar_tr($input);
	}

	private function _gerar_tr($campo)
	{
		$nome = Qi_Html::h($this->nome);
		$rotulo = Qi_Html::h($this->rotulo);
		return <<<HTML

	<tr>
		<td><label for="$nome">$rotulo</label></td>
		<td>$campo</td>
	</tr>

HTML;
	}

	private function _parse_tipo_tamanho($type)
	{
		if (strstr($type, "tinyint(1)") !== false):
            $this->tipo = self::BOOL;
            $this->tamanho = 1;
            return;
        endif;

		preg_match("/(\w+)\((.+)\)/", $type, $matches);

		if (isset($matches[1], $matches[2])):
			list($tudo, $tipo, $tamanho) = $matches;
			$this->tipo = strtoupper($tipo);
			$this->tamanho = $tamanho;
		endif;

		// utiliza $this->tamanho para armazenar as opes do ENUM
		// faz as formataes adequadas como retirar as aspas ao redor.
		if ($this->tipo == "ENUM"):
			$opcoes = explode(",", $this->tamanho);
			$this->tamanho = array();
			foreach($opcoes as $opcao):
				$opcao = trim($opcao, "\"' ");
				$this->tamanho[$opcao] = $opcao;
			endforeach;
		endif;
	}
}

?>