<?
class Qi_Db_PaginacaoURL extends Qi_It_MySql
{
	public $itens_por_pagina = 12;
	public $pagina_atual = 1;
	public $offset = 0;
	public $ultima_pagina = 0;
	public $total_itens = 0;
	public $total_paginas = 0;
	public $variavel_de_paginacao = "p";

	/**
	 * Separar o sql, para permitir paginação sobre qualquer iterator
	 */
	public function __construct($sql, $itens_por_pagina = 12, $pagina_atual = 1)
	{
		$pagina_atual = max(1, $pagina_atual);
		if (intval($itens_por_pagina) <= 0) throw new Exception("\$itens_por_pagina '$itens_por_pagina' deve ser maior que zero");
		if ( strripos($sql, "SQL_CALC_FOUND_ROWS") === false )
			$sql = preg_replace("/SELECT/i", " SELECT SQL_CALC_FOUND_ROWS ", $sql, 1);

		$this->itens_por_pagina = $itens_por_pagina;
		$this->offset = ($pagina_atual-1) * $this->itens_por_pagina;
		$offset = $this->offset;
		$sql .= " LIMIT $offset, $itens_por_pagina";
		parent::__construct(Qi_Db::query($sql)->result);
		$this->total_itens = current(Qi_Db::query("SELECT found_rows()")->current());
		$this->total_paginas = ceil($this->total_itens/$itens_por_pagina);
		$this->ultima_pagina = max($this->total_paginas, 1);
		$this->pagina_atual = $pagina_atual;
	}

	/**
	 * Gera um combobox com todas as páginas existentes
	 */
	public function select()
	{
		$options = Qi_Html_Option::numerico(1, $this->total_paginas, $this->pagina_atual);
		$var = $this->variavel_de_paginacao;
		return <<<EOF
		<select name="$var" class="paginador">
			$options
		</select>
EOF;
	}

	/**
	 * Gera navegação no estilo: primeiro anterior 1 2 3 4 5 próximo último
	 * Isolar o cálculo de paginação em outra classe para reaproveitar em outro contexto
	 */
	public function navegacao_numerada($conf = array())
	{
		$padrao = array("qtde_paginas_exibidas" => 5);
		extract($padrao);
		extract($conf);
		$html = "";

		$metade = floor($qtde_paginas_exibidas/2);
		$antes = $metade;
		$depois = $metade;

		if ($qtde_paginas_exibidas % 2 == 0)
			$antes = $metade - 1; // o meio de 1 2 3 4 5 6 é 3, o mesmo para 1..7

		$first = min($this->pagina_atual - $antes, $this->total_paginas - $qtde_paginas_exibidas + 1);
		$inicio = max(1, $first);
		$last = max($this->pagina_atual + $depois, $qtde_paginas_exibidas);
		$ultima_pagina_para_exibir = min($last, $this->total_paginas);

		parse_str($_SERVER["QUERY_STRING"], $variaveis);
		for($i = $inicio; $i <= $ultima_pagina_para_exibir; $i++):
		$variaveis[$this->variavel_de_paginacao] = $i; // atualiza a variável de paginação, por padrão "p"
		$link = $variaveis[$this->variavel_de_paginacao];//http_build_query($variaveis);
		$class = $this->pagina_atual == $i ? " atual" : "";
		if ($i == $inicio) $class .= " first";
		if ($i == $ultima_pagina_para_exibir) $class .= " last";
		$html .= <<<EOF
<div id="pagina" class="paginador $class">
	<a href="p=$link">
		$i
	</a>
</div>

EOF;
		endfor;

		return $html;
	}

	public function navegacao($conf = array())
	{
		$padrao["primeiro"] = "<img src='imgs/arrow_leftend_off.png'/>";
		$padrao["anterior"] = "<img src='imgs/arrow_left_off.png'/>";
		$padrao["proximo"]  = "<img src='imgs/arrow_right_off.png'/>";
		$padrao["ultimo"]   = "<img src='imgs/arrow_rightend_off.png'/>";


		extract($padrao);
		extract($conf);

		$html = "";

		if ($this->pagina_atual > 1):
		$html .= $this->navegador("primeiro", $padrao["primeiro"], 1);
		$html .= $this->navegador("anterior", $padrao["anterior"], $this->pagina_atual - 1);
		endif;

		$html .= $this->navegacao_numerada($conf);

		if ($this->pagina_atual < $this->ultima_pagina):
		$html .= $this->navegador("proximo", $padrao["proximo"], $this->pagina_atual + 1);
		$html .= $this->navegador("ultimo" , $padrao["ultimo" ], $this->ultima_pagina);
		endif;

		return $html;
	}

	public function navegacao_site($conf = array())
	{
		$padrao["primeiro"] = "<<";
		$padrao["anterior"] = "<";
		$padrao["proximo"]  = utf8_decode(">");
		$padrao["ultimo"]   = utf8_decode(">>");


		extract($padrao);
		extract($conf);

		$html = "";

		if ($this->pagina_atual > 1):
		$html .= $this->navegador("primeiro", $padrao["primeiro"], 1);
		$html .= $this->navegador("anterior", $padrao["anterior"], $this->pagina_atual - 1);
		endif;

		$html .= $this->navegacao_numerada($conf);

		if ($this->pagina_atual < $this->ultima_pagina):
		$html .= $this->navegador("proximo", $padrao["proximo"], $this->pagina_atual + 1);
		$html .= $this->navegador("ultimo" , $padrao["ultimo" ], $this->ultima_pagina);
		endif;

		return $html;
	}

	private function navegador($class, $rotulo, $pagina)
	{
		parse_str($_SERVER["QUERY_STRING"], $variaveis);
		$variaveis[$this->variavel_de_paginacao] = $pagina;
		$link = $variaveis[$this->variavel_de_paginacao];//http_build_query($variaveis);
		return <<<EOF
<span class="$class"><a href="p=$link">$rotulo</a></span>

EOF;
	}
}


?>