<?

/* ================================================================================

Como Usar:
$mail = new Qi_Email_Contato;
$mail->enviar(); // automaticamente se configura baseado nos dados do POST|GET

Para enviar um email de teste, basta informar o email de origem 
com um email igual ao email da propriedade $para_teste (marcos.neves@gmail.com)

@todo Ajustar timezone
@todo Identificar se o cliente  uma pgina, uma requisio Ajax ou um Flash,
		e responder apropriadamente.
@todo Criar tambm um gerador de formulrio padro
@todo Criar uma resposta padro
@todo Validar os campos obrigatrios (campos vazios, email, cpf, cnpj, cep, endereo)
@todo Criar verso view html
@todo Introduzir suporte a templates
@todo Limpar o post para evitar F5
================================================================================ */

class Qi_Email_Contato
{

	public $de = null;
	public $para = null;
	public $para_teste = "marcos.neves@gmail.com";
	public $assunto = null;
	public $mensagem = null;
	/**
	 * usar esta varivel para setar a mensagem diretamente.
	 * Cada varivel abaixo, se mantida no original, 
	 * sero construdas automaticamente apartir das variveis acima.
	 */
	public $corpo = null;
	public $campos = array();
	public $headers = array();
	public $duracao;

	/**
	* campos ignorados no relatorio da mensagem
	*/
	public $camposInvalidos = array("submit", "x", "y", "mensagem", "msg", "enviar", "send", "post", "max_file_size", "submit_x", "submit_y");

	public function __construct()
	{
		$this->headers["X-Mailer"] = "qi64Mailer, PHP " . phpversion();
		$this->headers["Content-Type"] = "text/plain; charset=ISO-8859-1";
		$this->headers["Script"] = $this->_testEmailInjection($_SERVER['HTTP_HOST'].$_SERVER["REQUEST_URI"]);
		if (isset($_SERVER["HTTP_REFERER"]))
			$this->headers["Referer"] = $this->_testEmailInjection($_SERVER["HTTP_REFERER"]);
	}

	public function enviar()
	{
		$this->_autoPreencherPropriedades();

		$corpo = $this->corpo ? $this->corpo : $this->_buildCorpo();
		$headers = $this->_buildHeaders();

		$para = $this->_testEmailInjection($this->para);
		$assunto = $this->_testEmailInjection($this->assunto);

		$inicio = microtime(true);
			$sucesso = @mail($para, $assunto, $corpo, $headers); // arroba para no exibir warning
		$this->duracao = number_format(microtime(true) - $inicio, 2);

		if ($sucesso === false)
			throw new Exception("
No foi possvel enviar email:
Para($para)
Assunto($assunto)
Headers($headers)
Corpo($corpo)

"			);
		return true;
	}


	private function _autoPreencherPropriedades()
	{
		if (empty($this->campos)) $this->campos = $_POST;
		if (empty($this->campos)) $this->campos = $_GET;

		$this->campos = array_change_key_case($this->campos, CASE_LOWER);
		$this->campos = array_map("trim", $this->campos);

		if (is_null($this->de))
			$this->de = $this->_isset($this->campos, "email de from", "email@nao.informado");

		if (is_null($this->mensagem))
			$this->mensagem = $this->_isset($this->campos, "mensagem msg message", "Mensagem Vazia!");

		if (is_null($this->assunto))
			$this->assunto = $this->_isset( $this->campos, "assunto subject", "Contato pelo Site " . $this->_getHost() );

		if (is_null($this->para))
			$this->para = $this->_isset($this->campos, "para to", $this->para_teste);

		if ($this->de == $this->para_teste):
			$this->para = $this->para_teste;
			$this->assunto = "TESTE-" . $this->assunto;
		endif;
	}


	private function _isset(array $src, $opcoes, $default)
	{
		$opcoes = explode(" ", $opcoes);
		foreach($opcoes as $opcao)
			if (isset($src[$opcao]))
				return $src[$opcao];

		return $default;
	}


	private function _buildCorpo()
	{
		$site = $this->_getHost();
		$dataHora = date("d/m/Y \s H:i:s");
		$ip = $_SERVER["REMOTE_ADDR"];
		$campos = $this->_buildCampos();
		return "Contato enviado dia $dataHora,
atravs do formulrio no site $site
pelo cliente de IP $ip.
$campos
$this->mensagem";
	}


	private function _buildCampos()
	{
		$campos = "\n";
		foreach ($this->campos as $nome=>$valor):
			if ($this->_ehCampoInvalido($nome)) continue;
			$nome = ucfirst(strtolower(trim($nome)));
			$valor = trim($valor);
			$campos .=  "$nome: $valor\n";
		endforeach;
		return $campos;
	}


	private function _ehCampoInvalido($label)
	{
		$label = strtolower($label);
		return in_array($label, $this->camposInvalidos);
	}


	private function _buildHeaders()
	{
		if ( ! isset($this->headers["From"]) )
			$this->headers["From"] = $this->de;

		$headers = "";
		foreach ($this->headers as $nome=>$valor):
			$this->_testEmailInjection($nome);
			$this->_testEmailInjection($valor);
			$nome = trim(ucwords($nome));
			$valor = trim($valor);
			$headers .= "$nome: $valor\n";
		endforeach;
		return $headers;
	}


	private function _testEmailInjection($str)
	{
		if (eregi("\r|\n|%0D|%0A", $str) !== false)
			throw new Exception("Email Injection em: ($str)");
		return $str;
	}


	private function _getHost()
	{
		$host = isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : $_SERVER['HTTP_HOST'];
		$url = parse_url($host, PHP_URL_HOST);
		return $url ? $url : $host;
	}

}

?>