<?

/**
* Toda a gerao de options no framework  feito por esta classe
@TODO option para datas, dias, anos, horas, combo para date e datetime
@TODO option de estados, pases
@TODO criar um option que mostra os estados agrupados por regio
*/
class Qi_Html_Option
{
	/**
	* Gera apenas os options para serem usados dentro de um <select>
	*/
    public static function gerar($traversable, $selecionado = null)
    {
        $option = "";
        foreach($traversable as $valor => $rotulo):
            if (is_array($rotulo)):
                $valor = reset($rotulo);
                $rotulo = end($rotulo);
            endif;
            $rotulo = htmlspecialchars($rotulo);
            $selected = is_null($selecionado) || $valor != $selecionado ? "" : ' selected="selected"';
            $option .= "\t<option value=\"$valor\"$selected>$rotulo</option>\n";
        endforeach;
        return $option;
    }

	/**
	* Gera os options agrupados por optgroup
	* $traversable deve ter a chave como o rtulo e o valor como outro traversable
	* que ser usado por self::gerar()
	* optgroup no suporta mais que 1 nvel de profundidade!
	*/
	public static function gerar_por_grupo($traversable, $selecionado = null)
	{
		$option = "";
		foreach($traversable as $rotulo => $grupo):
			$options = self::gerar($grupo, $selecionado);
			$class = Qi_Util::id($rotulo);
			$class = htmlspecialchars($class);
			$rotulo = htmlspecialchars($rotulo);
			$option .= "<optgroup class=\"$class\" label=\"$rotulo\">\n$options</optgroup>\n";
		endforeach;
		return $option;
	}

	/**
	* Retorna uma lista de options com as siglas dos estados do Brasil
	*/
	public static function uf($selecionado = null)
	{
		return self::gerar(Qi_Uf::$SIGLAS, $selecionado);
	}

	/**
	* Mesmo acima, mas mostra os nomes dos estados por extenso
	*/
	public static function estados($selecionado = null)
	{
		return self::gerar(Qi_Uf::$NOMES, $selecionado);
	}

	public static function estados_por_regiao($selecionado = null)
	{
		return self::gerar_por_grupo(Qi_Uf::$REGIOES, $selecionado);
	}

	/**
	* Executa a sql e utiliza o primeiro e ltimo campo como chave e valor
	*/
	public static function sql($sql, $selecionado = null)
	{
		$tabela = Qi_Db::query($sql);
		return self::gerar(new Qi_It_ChaveValor($tabela), $selecionado);
	}

	/**
	* Gera um option com uma sequencia numrica
	*/
	public static function numerico($inicio, $fim, $selecionado = null, $passos = 1)
	{
		$range = range($inicio, $fim, $passos);
		$range = array_combine($range, $range);
		return self::gerar($range, $selecionado);
	}
}

?>