<?

class Qi_Http
{
	/**
	 * Redireciona para a pgina informada e mata o script
	**/
	public static function desviar($destino)
	{
		if ( headers_sent($arquivo, $linha) ) die ("
No foi possvel redirecionar para [$destino], pois foi gerado uma sada no arquivo [$arquivo] linha [$linha].
Remova nesta linha qualquer espao, echo, mensagem de erro, ou qualquer cdigo que esteja gerando esta sada.
");
		header("Location: $destino");
		exit;
	}
	
	public static function modo_texto()
	{
		header("Content-Type: text/plain");
	}

	/**
	* @return bool true se a requisio foi feita por POST
	*/
	public static function eh_POST()
	{
		return isset($_SERVER["REQUEST_METHOD"]) && strtoupper($_SERVER["REQUEST_METHOD"]) == "POST";
	}

	/**
	 * Refresh na prpria pgina, til para limpar o $_POST
	 **/
	public static function recarregar()
	{
		if (self::eh_POST())
			self::desviar($_SERVER["REQUEST_URI"]);
		else
			die("S  possvel recarregar a pgina aps um mtodo POST");
	}

	/**
	 * Retorna para a pgina anterior, atravs do cabealho REFERER,
	 * Caso no exista, ele recarrega a prpria pgina.
	**/
	public static function voltar()
	{
		if ( ! isset($_SERVER["HTTP_REFERER"]) )
			self::recarregar();
		else
			self::desviar($_SERVER["HTTP_REFERER"]);
	}
}

?>