<?

class Qi_Img
{
	public $resource = null;
	public $largura = 0;
	public $altura = 0;

	/**
	* $arquivo_resource_largura pode ser uma string com o nome do arquivo,
	* um resource to tipo gd, ou um inteiro com a largura da imagem,
	* utilizado junto com a altura.
	*/
	public function __construct($arquivo_resource_largura, $altura = null)
	{
		if (is_null($altura))
				$this->resource = self::carregar($arquivo_resource_largura);
		else
			$this->resource = imagecreatetruecolor($arquivo_resource_largura, $altura);
		$this->largura = imagesx($this->resource);
		$this->altura = imagesy($this->resource);
	}

	/**
	* Destroy o resource da imagem, para liberar memria
	*/
	public function __destruct()
	{
		imagedestroy($this->resource);
	}

	/**
	* pode ser uma string com o nome do arquivo ou um resource to tipo gd.
	*/
	public static function carregar($imagem)
	{
		if (is_string($imagem)):
			if (is_readable($imagem)):
				return imagecreatefromjpeg($imagem);
			else:
				throw new Exception("Imagem no pode ser lida ($imagem)");
			endif;
		elseif (is_resource($imagem)):
			$type = strtolower(get_resource_type($imagem));
			if ($type == "gd"):
				return $imagem;
			else:
				throw new Exception("Resource informado no  do tipo GD: $type");
			endif;
		else:
			throw new Exception("Informe um resource GD ou o caminho de uma imagem ($imagem)");
		endif;
	}

	/**
	* Retorna uma imagem com a largura e altura informada.
	* Para manter um campo proporcional, informe null ou um nmero <= 0
	* @TODO: criar um parmetro que diz se dever aumentar imagens menores que o tamanho definido.
	*/
	public function redimensionar($largura, $altura)
	{
		if ($altura <= 0)
			$altura = $this->altura*$largura/$this->largura;
		if ($largura <= 0)
			$largura = $this->largura*$altura/$this->altura;
		$nova = new Qi_Img($largura, $altura);
		Qi_Img::resample($this, $nova);
		return $nova;
	}

	/**
	* @TODO: achar o clculo para centralizar o crop
	*/
	public function crop($largura, $altura)
	{
		$nova_proporcao = $largura / $altura;
		if ($this->proporcao() < $nova_proporcao):
			// crop_vertical
			$destino = new Qi_Img($largura, $altura);
			$altura_na_origem = $this->altura/$nova_proporcao;
			$altura_na_origem = min($altura_na_origem, $this->altura);
			imagecopyresampled(
				$destino->resource,
				$this->resource,
				0, 0, // destino
				0, $this->altura/2 - $altura_na_origem/2,
				$destino->largura, $destino->altura,
				$this->largura, $altura_na_origem
			);
		else:
			return;
		endif;
			// crop_horizontal
		return $destino;
	}

	public function eh_quadrada()
	{
		return $this->largura == $this->altura;
	}

	public function eh_vertical()
	{
		return $this->largura < $this->altura;
	}

	public function eh_horizontal()
	{
		return $this->largura > $this->altura;
	}

	public function proporcao()
	{
		return $this->largura / $this->altura;
	}

	/**
	* Retorna uma imagem com as dimenses no maiores que a largura e altura informada.
	*/
	public function enquadrar($largura_max, $altura_max)
	{
		$nova_proporcao = $largura_max / $altura_max;
		if ($this->proporcao() < $nova_proporcao)
			return $this->redimensionar(null, $altura_max);
		else
			return $this->redimensionar($largura_max, null);
	}

	/**
	* wrapper sobre a funo imagecopyresampled, para aceitar duas imagens Qi_Img
	*/
	public static function resample(Qi_Img $origem, Qi_Img $destino)
	{
		imagecopyresampled(
			$destino->resource,
			$origem->resource,
			0, 0,
			0, 0,
			$destino->largura, $destino->altura,
			$origem->largura, $origem->altura
		);
	}

	/**
	* O valor de qualidade utilizado pelo GD, oferece resultados 
	* inferiores a compactao do photoshop ou fireworks.
	* Uma imagem com qualidade 70 e tamanho 100x100, tem compactao e qualidade melhor que a do GD.
	* Esta funo equilibra a qualidade da imagem JPEG,
	* naseado nas suas dimenses, retornando uma qualidade entre 70 e 95,
	* onde 95  para uma imagem de 100x100 ou menor e 70 para uma imagem de 700x700 ou maior.
	* Portanto quanto menor a imagem, maior deve ser a qualidade.
	*/
	private function calcular_qualidade()
	{
		$n = sqrt($this->largura*$this->altura);
		$q = $n * -0.04 + 99;
		return round(max(70, min($q, 95)));
	}

	/**
	* se o destino no for informado, a imagem ser enviada para o browser.
	* no lugar do destino, pode-se informado o formato, quando a imagem for enviada para o browser.
	* Esta funo j gera os cabealhos necessrios.
	* A qualidade  aplicada apenas para imagens JPEG.
	* Quando a imagem for JPEG e a sada for o browser, o cabealho 
	* JPEG-Quality  enviado contendo a qualidade utilizada naquela imagem.
	* Quando a sada for o browser, o cabealho memory_get_peak_usage  retornado contendo
	* quantos MB foram alocados na execuo deste script.
	* @param $qualidade int Inteiro normalmente entre 60 e 95
	*/
	public function salvar($destino = "", $formato = "jpeg", $qualidade = null)
	{
		if (is_null($qualidade)):
			$qualidade = $this->calcular_qualidade();
		endif;

		if (is_numeric($destino)):
			$formato = $destino;
			$destino = "";
		endif;

		$memory = round(memory_get_peak_usage(true)/1024/1024, 1);
		if ($destino == "") header("memory_get_peak_usage: $memory MB");

		$formato = strtolower($formato);
		switch($formato):
			case "jpeg":
			case "jpg":
			case IMAGETYPE_JPEG:
				if ($destino == ""):
					header("Content-Type: image/jpeg");
					header("JPEG-Quality: $qualidade");
				endif;
				imagejpeg($this->resource, $destino, $qualidade);
			break;

			case "png":
			case IMAGETYPE_PNG:
				if ($destino == ""):
					header("Content-Type: image/png");
					imagepng($this->resource);
				else:
					imagepng($this->resource, $destino);
				endif;
			break;

			case "gif":
			case IMAGETYPE_GIF:
				if ($destino == ""):
					header("Content-Type: image/gif");
					imagegif($this->resource);
				else:
					imagegif($this->resource, $destino);
				endif;
		endswitch;
	}
}

?>