<?

/**
* Captura as vari�veis pr�-definidas do PHP
* Para isso, este arquivo deve ser executado no escopo global,
* n�o dentro de uma fun��o ou m�todo.
*/
Qi_Init::$VARIAVEIS_PADROES = array_keys(get_defined_vars());

/**
 * @TODO na ferramenta de relat�rio, colocar a fun��o memory_get_peak_usage
 * @TODO se a vers�o do PHP for mais antiga, incluir um arquivo de compatibilidade
*/

define("QI_INICIADO_EM", microtime(true)); //@TODO implementar log de execu��o. Extens�o para firefox?

// configurar o PHP
ini_set("session.bug_compat_warn", "off"); // desligar mensagem de erro in�til.
ini_set("html_errors", "off");
ini_set("display_errors", "on");
/** @TODO fazer mais testes pois quando uma exception ocorre uma vez, ele n�o mostra mais
ini_set("ignore_repeated_errors", "on");
ini_set("ignore_repeated_source", "off");
*/
ini_set("log_errors", "off");

// setar o arquivo de log
$hoje = date("y-m-d");
ini_set("error_log", @$_SERVER["DOCUMENT_ROOT"]."/qi_error_log.".$hoje.".log"); // @TODO verificar permiss�o de escrita
unset($hoje);

// n�o faz append nem prepend no arquivo de log, apenas na tela.
ini_set("error_prepend_string", "\n");
ini_set("error_append_string", "\n\n");

// registra os autoloads
Qi_Init::init();

/*	
	para n�o incluir os atalhos, sete esta vari�vel para false, antes de incluir o qi/init. Exemplo:
	$incluir_atalhos = false;
	require_once "qi/init.php";
*/
$incluir_atalhos = isset($incluir_atalhos) ? (bool)$incluir_atalhos : true;
if ($incluir_atalhos) require_once dirname(__FILE__)."/atalhos.php";
unset($incluir_atalhos);

class Qi_Init
{
	/**
	* Nome de todas vari�veis pr�-definidas no PHP,
	* capturadas logo no come�o da execu��o deste script
	*/
	public static $VARIAVEIS_PADROES = array();

	/**
	* A chave � o nome da classe e os valores possuem o caminho do arquivo
	* onde a classe foi encontrada e os tempos: inicio, fim e duracao
	* em valores microtime
	* @TODO Adicionar no array a quantidade de mem�ria antes e depois de carregar a classe
	*/
	public static $classes_carregadas = array();

	/**
	* Registra o autoload do framework, autoload do PEAR e autoload gen�rico.
	* @TODO extrair os c�digos de autoload para uma classe separada, Qi_AutoLoad
	*/
	public static function init()
	{
		spl_autoload_register(array("Qi_Init", "qi_autoload_framework"));
		spl_autoload_register(array("Qi_Init", "qi_autoload_pear"));
		spl_autoload_register(array("Qi_Init", "qi_autoload_generico"));
	}

	/**
	* tempo total em segundos gastos carregando arquivos do framework
	* Subtraindo este valor do tempo total da execu��o, � poss�vel saber o tempo
	* total perdido apenas dentro da aplica��o
	*/
	public static function duracao_total()
	{
		$soma = 0;
		foreach(self::$classes_carregadas as $info)
			$soma += $info["duracao_segundos"];
		return $soma;
	}

	/**
	* @TODO implementar
	*/
	private static function qi_autoload_pear($classe)
	{
		return false;
	}

	/**
	* @TODO implementar
	*/
	private static function qi_autoload_generico($classe)
	{
		return false;
	}

	/**
	* procurar por min�sculo, normal e criar outro autoload para classes fora do qi, mas que estejam no include_path e sigam uma nomenclatura, padr�o
	* @TODO criar autoload para as classes do PEAR, que tamb�m obedecem uma nomenclatura.
	*/
	private static function qi_autoload_framework($class)
	{
		$dados["inicio"] = microtime(true);
		// carrega apenas classes do framework qi_*
		$prefixo = strtolower(substr($class, 0, 3));
		if ($prefixo != "qi_") return false; //carrega apenas o framework

		$path = strtr($class, "_", "/");
		$path = strtolower($path);
		$dir = dirname(dirname(__FILE__));
		$path = "$dir/$path.php";
		if ( file_exists($path) ):
			self::_require_once($path);
			$dados["path"] = $path;
			$dados["fim"] = microtime(true);
			$dados["duracao_segundos"] = round($dados["fim"] - $dados["inicio"], 4);
			$dados["duracao_ms"] = round(($dados["fim"] - $dados["inicio"])*1000, 1);
			self::$classes_carregadas[$class] = $dados;
		else:
			//trigger_error("N�o existe o arquivo [$path] para a classe [$class]", E_USER_WARNING);
			//*/ o c�digo abaixo transforma a inexist�ncia da classe em um exce��o. 
			eval("class $class {}"); // Para a exce��o ser disparada, � preciso que a classe seja encontrada.
			throw new Exception("N�o existe o arquivo [$path] para a classe [$class]");
			//*/
		endif;
	}

	/**
	* Faz require em um escopo separado, para n�o acabar sobrescrevendo sem querer
	* alguma vari�vel global no arquivo carregado.
	*/
	private static function _require_once($_QI_CLASS_PATH)
	{
		require_once $_QI_CLASS_PATH;
	}
}

?>