<?

/**
Apenas um iterator sobre o resource mysql result

Usar nomes em portugus sempre que possvel
Manter todas as classes em arquivos separados e o mais simples possvel, sem querer abraar o mundo.
A nomenclatura seguir o padro de namespace do Zend, inclusive usando camel humbs
Esta classe est focada para o mysql, descobrir uma maneira de extender para sqlite
melhorar o controle de excees, manter sempre informaes detalhadas para encontrar facilmente o erro.
Criar uma classe externa para estes tipos comuns de validao de dados
**/

class Qi_It_MySql implements Iterator, Countable, ArrayAccess
{
	public $result;
	private $linha_atual = array();
	private $key = -1;
	private $valid = false;

	public function __construct($result)
	{
		Qi_Db::try_mysql_resource($result);

		$this->result = $result;
		$this->_proxima_linha();
	}

	/**
	* Apenas retorna um valor qualquer caso seja chamado por engano em um contexto
	* de string.
	* @TODO ficar atento para alguma utilidade prtica deste mtodo.
	*/
	public function __toString()
	{
		return implode(", ", $this->current());
	}
	
	public function colunas()
	{
		return array_keys($this->linha_atual);
	}

	/**
	* para exibir clulas vazias utilizar: table { empty-cells:show; }
	* @TODO, adicionar algumas classes para auxiliar na formatao da tabela por CSS
	*/
	public function toHtmlTable()
	{
		$xml = new Qi_Xml_Builder("table", 'class="mysql"');

		// header
		$tr = $xml->thead()->tr();
		foreach($this->colunas() as $coluna)
			$tr->th("", $coluna);
		$xml->tfoot("", $tr);
		
		//body
		$body = $xml->tbody();
		foreach ($this as $linha):
			$tr = $body->tr();
			foreach($linha as $v):
				$tr->td("", (string)$v);
			endforeach;
		endforeach;

		return $xml->asXml();
	}

	public function to_a()
	{
		return iterator_to_array($this);
	}

	/**
	* @return Retorna o primeiro valor da linha atual.
	* Excelente para querys que retornam um nico valor, exemplo:
	* Qi_Db::query("SELECT version()")->valor()
	* Qi_Db::query("SELECT now()")->valor()
	*/
	public function valor()
	{
		$current = $this->current();
		return reset($current);
	}

	// implementao Countable
	public function count()
	{
		return mysql_num_rows($this->result);
	}

	// implementao Iterator
	/**
	* Sempre retorna um array. Quando acaba, retorna um array vazio!
	*/
	public function current()
	{
		return $this->linha_atual;
	}

	public function key()
	{
		return $this->key;
	}

	public function next()
	{
		$this->key++;
		return $this->_proxima_linha();
	}

	private function _proxima_linha()
	{
		$this->valid = true;
		$this->linha_atual = mysql_fetch_assoc($this->result);
		if ($this->linha_atual === false):
			$this->linha_atual = array();
			$this->valid = false;
		endif;
		return $this->linha_atual;
	}

	public function rewind() 
	{
		if($this->count() > 0):
			mysql_data_seek($this->result, 0);
			$this->_proxima_linha();
			$this->key = 0;
		else:
			$this->key = -1;
		endif;
	}

	public function valid()
	{
		return $this->valid;
	}

	// implementao ArrayAccess
	public function offsetExists($offset)
	{
		return isset($this->linha_atual[$offset]);
	}

	public function offsetGet($offset)
	{
		if ($this->offsetExists($offset))
			return $this->linha_atual[$offset];
		if (empty($this->linha_atual))
			throw new RuntimeException("O resultado do banco est vazio!");
		$opcoes = array_keys($this->linha_atual);
		$similar = new Qi_Util_Similar($opcoes, $offset);
		$sugestao = $similar->sugestao();
		$opcoes = implode('|', $opcoes);
		$msg = "O campo [$offset] no existe no resultado do MySql!
Voc no quis dizer [$sugestao]?
As opes vlidas so:\n[$opcoes]
";
		throw new OutOfRangeException($msg);
	}

	public function offsetSet($offset, $value)
	{
		$this->linha_atual[$offset] = $value;
	}

	public function offsetUnset($offset)
	{
		unset($this->linha_atual[$offset]);
	}

	// implementao Overloading
	public function __get($offset)
	{
		return $this[$offset];
	}

	public function __set($offset, $value)
	{
		$this[$offset] = $value;
	}

	public function __isset($offset)
	{
		return $this->offsetExists($offset);
	}

	public function __unset($offset)
	{
		return $this->offsetUnset($offset);
	}
}

?>