<?

/**
* @TODO Criar uma maneira fcil de implementar vrios tipos de verificaes de usuario => senha
* @TODO Criar uma maneira fcil de alterar a pgina de login, talvez usar uma varivel com o caminho de um template.
* @TODO Usar esta classe para armazenar informaes do objeto "usurio logado", id, email, etc
*/
class Qi_Login
{
	public static $falhou = false;

	/**
	* nome usado no $_SESSION para armazenar true quando o usurio estiver logado
	*/
	const SESSION_VAR = "USUARIO_LOGADO";
	
	/**
	* nome para um campo que nunca exestir em post algum,
	* pois o protege  carregado em todas as pginas.
	* Este campo indica quando se deve fazer a verificao de usurio e senha
	*/
	const HIDDEN_NAME = "Qi_Login::VERIFICAR_USUARIO_SENHA";

	/**
	* @param $usuarios_senhas array com chave usuario => senha
	* cria o verificador. Pode ser extendido em uma classe filha para modificaes
	*/
	public static function permitir($usuarios_senhas)
	{
		if ( isset($_POST[self::HIDDEN_NAME]) )
			self::_tentar_logar($usuarios_senhas);
		else
			self::_proteger();
	}

	/**
	* Este  o principal mtodo da classe, que contm a lgica principal.
	* Verifica o usurio e senha informado e mostra a pgina desejada ou a pgina de login.
	*/
	protected static function _tentar_logar($usuarios_senhas)
	{
		list($usuario, $senha) = self::_entrada_usuario_senha();

		self::$falhou = ! self::_verificar_usuario_senha($usuarios_senhas, $usuario, $senha);
		if (self::$falhou):
			self::_destruir_sessao();
			self::_mostrar_pagina_login($usuario);
		else:
			@session_start();
			$_SESSION[self::SESSION_VAR] = true;
		endif;
	}

	/**
	* Mtodo executado apenas para proteger a pgina, verificando se o usurio est logado.
	*/
	protected static function _proteger()
	{
		@session_start();
		if ( ! isset($_SESSION[self::SESSION_VAR]) )
			self::_mostrar_pagina_login();
	}

	/**
	* Verifica o usurio e senha no array interno de opes (case-insensitive)
	*/
	protected static function _verificar_usuario_senha($usuarios_senhas, $usuario, $senha)
	{
		$usuario = strtolower($usuario);
		$senha = strtolower($senha);
		$usuarios_senhas = array_map("strtolower", $usuarios_senhas);
		return isset($usuarios_senhas[$usuario])
				  && $usuarios_senhas[$usuario] == $senha;
	}

	/**
	* Apenas extrai o usurio e senha do formulrio enviado de login
	*/
	protected static function _entrada_usuario_senha()
	{
			if (! isset($_POST["usuario"], $_POST["senha"]) )
				die ("Campos 'usuario' e 'senha' no informados no formulrio de login!");

			$usuario = $_POST["usuario"];
			$senha = $_POST["senha"];
			if (get_magic_quotes_gpc()):
				$usuario = stripslashes($usuario);
				$senha = stripslashes($senha);
			endif;
			return array($usuario, $senha);
	}

	/**
	* Destroy a sesso interna e o cookie no browser do cliente
	*/
	protected static function _destruir_sessao()
	{
		@session_start();
		$_SESSION = array();
		// se o cookie existir, seta seu valor no passado
		if (isset($_COOKIE[session_name()]))
			setcookie(session_name(), '', time()-42000, '/');

		session_destroy();
	}

	/**
	* renderiza o html da pgina de login e j preenche o nome com o ltimo nome digitado (post)
	*/
	protected static function _mostrar_pagina_login($usuario = "")
	{
		// magic quotes j  removido em _entrada_usuario_senha()
		$usuario = htmlspecialchars($usuario);
		$hidden_name = htmlspecialchars(self::HIDDEN_NAME);
		$falhou = self::$falhou;
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
	"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
	<title>Login</title>

<script type="text/javascript">
window.onload = function() {
	try {
		document.forms[0].usuario.focus();
	}catch(e){}
}
</script>

<style>
	h2 {
		font: bold 20px Arial, Helvetica, sans-serif;
		color: #333;
	}
	body {
		text-align: center;
		color: #444;
		font-family: Arial, Helvetica, sans-serif;
	}
	td, th {
		font: bold 12px tahoma, Arial, Helvetica, sans-serif;
	}
	th {
		text-align: right
	}
	tfoot td {
		text-align: right;
	}
	.error{
		font: bold 10px tahoma, Arial, Helvetica, sans-serif;
		color: #FF3300;
		text-align: center;
	}
</style>
</head>
<body>

<form method="post">

	<h2>rea Restrita</h2>

  <? if($falhou): ?>
	  <div class="error">Usurio ou Senha incorretos!</div>
  <? endif ?>

	<table align="center">
		<tfoot>
			<tr>
				<td colspan="2">
					<input type="submit" value="Entrar" class="btLogin" />
				</td>
			</tr>
		</tfoot>

		<tr>
			<th>Usurio</th>
			<td><input name="usuario" value="<?=@ $usuario ?>" class="usuario" /></td>
		</tr>
		<tr>
			<th>Senha</th>
			<td><input name="senha" type="password" class="senha" /></td>
		</tr>
	</Table>

	<input name="<?=@ $hidden_name ?>" type="hidden" />

</form>

</body>
</html>
<?
		exit; // sempre que mostrar a pgina de login, matar a aplicao
	} // mostrar_pagina_login
} //class

?>