<?

/**
* Retorna informaes detalhadas de configurao referentes ao PHP
*/
class Qi_Tools_PhpInfo
{
	/**
	* Constante com a ltima verso disponvel do PHP
	*/
	const PHP_LATEST_VERSION = "5.2.5";

	/**
	* Algumas funes desta classe so muito demoradas,
	* como os dados no mudam, o resultado  guardado em cache para acelerar as prximas chamadas.
	*/
	private static $cache = array();

	/**
	* Verso do PHP
	* 
	*/
	public static function versao()
	{
		$version = phpversion();
		$msg = "PHP Version: $version\n";
		$compare = version_compare($version, self::PHP_LATEST_VERSION);
		if ($compare === 0):
			$msg .= "Congratulations, latest version!";
		elseif($compare === -1):
			$msg .= "Latest PHP Version: " . self::PHP_LATEST_VERSION . "\n";
			$compare = version_compare($version, "5.2");
			$msg .= $compare === -1 ? "PHP Version too old, please upgrade NOW!" : "";
		endif;
		return $msg;
	}

	/**
	* @TODO implementar parse do contedo, pois a pgina do PHP no possui cabealhos de modificao

	public static function check_php_new_version()
	{
		$ch = curl_init("http://www.php.net/ChangeLog-5.php");
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_HEADER, true);
		curl_setopt($ch, CURLOPT_NOBODY, true);
		//curl_setopt($ch, CURLOPT_TIMECONDITION, CURL_TIMECOND_IFMODSINCE);
		//curl_setopt($ch, CURLOPT_TIMEVALUE, time());
		$ret = curl_exec($ch);
		curl_close($ch);
		return $ret;
	}
	*/
	public static function rodando_como_modulo_ou_cgi()
	{
		return PHP_SAPI == "cgi-fcgi" 
				? PHP_SAPI . ":" . $_SERVER["ORIG_SCRIPT_NAME"]
				: PHP_SAPI;
	}

	/**
	* ip do cliente que estiver acessando a pgina 
	* No funciona no DOS, por no ter os ndices necessrios no $_SERVER
	*/
	public static function ip_do_cliente()
	{
		return $_SERVER["REMOTE_ADDR"];
	}

	/**
	* ip do servidor que estiver executando este script 
	* No funciona no DOS, por no ter os ndices necessrios no $_SERVER
	*/
	public static function ip_do_servidor()
	{
		return gethostbyname($_SERVER["HTTP_HOST"]);
	}

	/**
	* Data e Hora no servidor
	*/
	public static function datahora()
	{
		return date("d/m/Y H:i:s");
	}

	/**
	* Informaes do usurio que est executando o script
	*/
	public static function usuario_executando_script()
	{
		$info["user"] = get_current_user();
		$info["id"] = getmyuid();
		$info["pid"] = getmypid();
		// usar posix_* para pegar mais informaes quando no linux (posix_getegid, ...)
		return $info;
	}

	/**
	* Retorna as configuraes e seus valores explicitamente definidos no php.ini
	* no retorna valores configurados no httpd.conf, .htaccess muito menos no prprio PHP
	* @param $nome string
	* @returns array nome => valor
	*/
	public static function php_ini($nome = null)
	{
		if (isset(self::$cache[__FUNCTION__])):
			if ($nome !== null)
				return isset(self::$cache[__FUNCTION__][$nome]) 
						? self::$cache[__FUNCTION__][$nome]
						: null;
			else
				return self::$cache[__FUNCTION__];
		endif;

		$ini_all = ini_get_all();
		$php_ini = array();
		foreach($ini_all as $ini=>$values):
			$valor = get_cfg_var($ini);
			// false quando o valor no est configurado no php.ini
			if ($valor === false) continue;
			$php_ini[$ini] = $valor;
		endforeach;

		self::$cache[__FUNCTION__] = $php_ini;
		return self::php_ini($nome);
	}

	/**
	* dado um codigo de acesso de uma propriedade de configurao,
	* @returns string nome deste acesso ou null caso no exista
	*/
	public static function access_name($access_code)
	{
		$access[7] = "PHP_INI_ALL";
		$access[6] = "PHP_INI_PERDIR";
		$access[4] = "PHP_INI_SYSTEM";
		$access[1] = "PHP_INI_USER";

		return isset($access[$access_code]) ? $access[$access_code] : null;
	}

	/**
	* retorna o array ini_get_all() adicionado access_name, php_ini, ini_padrao
	* ambos extrados dos mtodos com os respectivos nomes.
	* @TODO normalizar o array de ini do Qi_Tools_PhpInfo_Extensions
	*/
	public static function ini()
	{
		$ini_all = ini_get_all();
		$php_ini = array();
		foreach($ini_all as $nome => $values):
			$php_ini[$nome] = $values;
			$php_ini[$nome]["access_name"] = self::access_name($php_ini[$nome]["access"]);
			$php_ini[$nome]["php_ini"] = self::php_ini($nome);
			$php_ini[$nome]["ini_padrao"] = self::ini_padrao($nome);
		endforeach;

		return $php_ini;
	}

	/**
	* Apenas retorna o array global $_SERVER ordenado pelas chaves
	*/
	public static function server_vars()
	{
		$server = $_SERVER;
		Qi_Array::kcasesort($server);
		return $server;
	}

	/**
	* Verifica se tem permisso para executar php na linha de comando (se as funes no esto bloqueadas) (verificar todos os mtodos)
	* @TODO Verifica qual comando php  da verso 5, php ou php5, php-cgi ou php5-cgi
	* executa o php com -n (para no carregar .ini) e roda um cdigo que retorna uma string do array ini_get_all() serializado
	* desserializa o array e retorna um array nome => valor_padrao
	* se algum problema acontecer, retorna o array padro, um do linux e outro para windows (arrays pr definidos)
	*/
	public static function ini_padrao($nome = null)
	{
		if (isset(self::$cache[__FUNCTION__])):
			if ($nome !== null)
				return isset(self::$cache[__FUNCTION__][$nome])
						? self::$cache[__FUNCTION__][$nome]
						: null;
			else
				return self::$cache[__FUNCTION__];
		endif;
		$codigo = "echo serialize(ini_get_all());";
		$php = 'php';
		$exec = "$php -n -r \"$codigo\"";
		$serialize = Qi_Util::exec($exec);
		$ini_all = unserialize($serialize);

		$padrao = array();
		foreach ($ini_all as $k => $values):
			$padrao[$k] = $values["global_value"];
		endforeach;

		return self::$cache[__FUNCTION__] = $padrao;
	}

	/**
	* Retorna o nome de todos os mdulos compilados internamente no PHP,
	* atravs da execuo por linha de comando php -m -n (mostra modulos e no
	* carrega o arquivo php.ini, que pode carregar outros mdulos no compilados.
	* @TODO Verifica qual comando php  da verso 5, php ou php5, php-cgi ou php5-cgi
	*/
	public static function modulos_compilados()
	{
		if ( isset(self::$cache[__FUNCTION__]) ) return self::$cache[__FUNCTION__];

		$php = 'php';
		$exec = "$php -m -n";
		$saida = Qi_Util::exec($exec);

		$modulos = array();
		$linhas = split("\r\n|\r|\n", $saida);
		foreach($linhas as $linha):
			$linha = trim($linha);
			if ($linha == "") continue;
			if ($linha[0] == "[") continue;
			$modulos[$linha] = $linha;
		endforeach;

		natcasesort($modulos);
		return self::$cache[__FUNCTION__] = $modulos;
	}

	/**
	* todos_modulos menos os modulos_compilados(), retornando apenas os carregados
	*/
	public static function modulos_carregados()
	{
		return array_diff(Qi_Tools_PhpInfo_Extensions::extensions(), self::modulos_compilados());
	}
}

?>