<?

/**
* Retorna um array com todas as informaes sobre todas as extenses carregadas no PHP
*/
class Qi_Tools_PhpInfo_Extensions
{
	private static $todas = array();

	/**
	* @return array Mapeado pelo nome da extenso e 
	* suas respectivas funes, classes, constantes e configuraes ini
	*/
	public static function todas()
	{
		// Verifica o cache primeiro
		if ( ! empty(self::$todas) ) return self::$todas;

		$extensions = self::extensions();
		$todas = array();

			$todas["internal"]["version"] = phpversion();
			$todas["internal"]["functions"] = array();
			$todas["internal"]["classes"] = array();
			$todas["internal"]["interfaces"] = array();
			$todas["internal"]["ini"] = array();

			// Adiciona as CONSTANTS internas
			$const = get_defined_constants(true);
			$todas["internal"]["constants"] = Qi_Array::kcasesort($const["internal"]);

		foreach($extensions as $extension):
			$r = new ReflectionExtension($extension);
			$todas[$extension]["version"] 	 = $r->getVersion();
			$todas[$extension]["functions"]  = self::functions($extension);
			$todas[$extension]["classes"] 	 = self::classes($r);
			$todas[$extension]["interfaces"] = self::interfaces($r);
			$todas[$extension]["constants"]  = self::constants($r);
			$todas[$extension]["ini"] 		 = self::ini($r);
		endforeach;

		self::$todas = $todas;

			// Adiciona as INTERFACES internas
			$todas["internal"]["interfaces"] = 
				Qi_Array::natcasesort(
					array_diff(
						get_declared_interfaces(), 
						self::listar("interfaces")
					)
				);

			// Adiciona as FUNES internas
			$internal_functions = get_defined_functions();
			$internal_functions = $internal_functions["internal"];
			$todas["internal"]["functions"] = 
				Qi_Array::natcasesort(
					array_diff(
						$internal_functions,
						self::listar("functions")
					)
				);

			// Adiciona as CLASSES internas
			$classes = array_diff(get_declared_classes(), self::listar("classes"));
			$last = 0;
			foreach ($classes as $k=>$class)
				if ($k != $last++) break; // truque para ignorar as classes declaradas pelo usurio
				else $todas["internal"]["classes"][] = $class;
			Qi_Array::natcasesort($todas["internal"]["classes"]);

			// Adiciona as configuraes INI internas
			$ini = ini_get_all();
			$todas["internal"]["ini"] = 
				Qi_Array::kcasesort(
					array_diff_key(
						$ini, 
						self::listar("ini")
					)
				);

		return self::$todas = $todas;
	}

	/**
	* Agrupa por extenso, apenas o ndice requisitado.
	* Possveis ndices, so os ndices existentes no array de extenses acima:
	* version, functions, classes, interfaces, constants, ini
	*/
	public static function agrupar($indice)
	{
		$grupo = array();
		foreach(self::todas() as $nome => $info):
			$array = $info[$indice];
			if (empty($array)) continue;
			if (is_array($array))
				$grupo[$nome] = array_merge((array)@$grupo[$nome], $array);
			else
				$grupo[$nome] = $array;
		endforeach;
		return $grupo;
	}

	/**
	* Retorna um array unidimensional com todos os tens do ndice informado, 
	* de todas as extenses ou daquelas informadas no parmetro extensoes
	*/
	public static function listar($indice, $extensoes = array())
	{
		$extensoes = Qi_Util::to_a($extensoes);
		$extensoes = array_map("trim", $extensoes);
		$extensoes = array_map("strtolower", $extensoes);
		$lista = array();
		foreach(self::todas() as $nome => $info):
			$array = $info[$indice];
			if (empty($array)) continue;
			if ( !empty($extensoes) && !in_array(strtolower($nome), $extensoes) )
				continue;
			if (is_array($array))
				$lista = array_merge($lista, $array);
			else
				$lista[] = $array;
		endforeach;

		return in_array($indice, explode(" ", "constants ini")) 
			? Qi_Array::kcasesort($lista)
			: Qi_Array::natcasesort($lista);
	}

	/**
	* Retorna quantos elementos existem de determinado indice,
	* conforme os tipos suportados pelo mtodo agrupar($indice)
	*/
	public static function cont($indice)
	{
		return count(self::lista($indice));
	}

	/**
	* Retorna um array com todas as extenses carregadas
	*/
	public static function extensions()
	{
		$extensions = get_loaded_extensions();
		Qi_Array::natcasesort($extensions);
		return array_combine($extensions, $extensions);
	}

	// ==================== HELPERS, retornam informaes especficas sobre a extenso ====================
	
	/**
	* Funes definidas pela extenso
	*/
	public static function functions($extension)
	{
		$functions = get_extension_funcs($extension);
		return is_array($functions) ? Qi_Array::natcasesort($functions) : array();
	}

	/**
	* Classes definidas pela extenso
	*/
	public static function classes(ReflectionExtension $r)
	{
		$classes = $r->getClassNames();
		$interfaces = get_declared_interfaces();
		$classes = array_diff($classes, $interfaces); // remove da lista de classes, as interfaces
		return Qi_Array::natcasesort($classes);
	}

	/**
	* Interfaces definidas pela extenso
	*/
	public static function interfaces(ReflectionExtension $r)
	{
		$classes = $r->getClassNames();
		$interfaces = get_declared_interfaces();
		$interfaces = array_intersect($interfaces, $classes);
		return Qi_Array::natcasesort($interfaces);
	}

	/**
	* Constants definidas pela extenso
	*/
	public static function constants(ReflectionExtension $r)
	{
		$constants = $r->getConstants();
		Qi_Array::kcasesort($constants);
		return $constants;
	}

	/**
	* Configuraes ini definidas pela extenso
	*/
	public static function ini(ReflectionExtension $r)
	{
		$ini = $r->getINIEntries();
		Qi_Array::kcasesort($ini);
		return $ini;
	}
}

?>