<?

/**
 * Situaes de uso para Upload de arquivos:
anexo por email (integrar documentos com o googleDocs)
armazenados em uma pasta para download (criar funo em Qi_Util para converter uma string para nome vlido de arquivo)
mover para uma pasta
salvar com outro nome, mas mantendo a extenso
identificar o tipo do arquivo
validar baseado no tipo, tamanho do arquivo (min e maximo)
ter um mtodo para excluir o arquivo se por exemplo a insero no banco no tiver sucesso.
saber antes mesmo de salvar no banco, se o arquivo conseguir ser copiado para o destino (permisso de escrita, etc)
como o uso mais comum  upload de imagens, gerar thumbz, etc, possuir mtodos para auxiliar nisto.
verificar extenses perigosas como .sh, .cgi, .php, etc
ter grupos de tipos de arquivos como (imagens, documentos, compactados, executaveis, etc)
facilitar criao de testes
caso o diretrio de destino no exista, tenta cri-lo
se o diretrio for relativo, o far relativo ao diretrio atual
**/

class Qi_Upload
{
	public $tamanho = 0;
	public $nome = "";
	public $nome_tmp = "";
	public $tipo = "";
	/**
	UPLOAD_ERR_OK			Value: 0; There is no error, the file uploaded with success.
	UPLOAD_ERR_INI_SIZE		Value: 1; The uploaded file exceeds the upload_max_filesize directive in php.ini.
	UPLOAD_ERR_FORM_SIZE	Value: 2; The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form.
	UPLOAD_ERR_PARTIAL		Value: 3; The uploaded file was only partially uploaded.
	UPLOAD_ERR_NO_FILE		Value: 4; No file was uploaded.
	UPLOAD_ERR_NO_TMP_DIR	Value: 6; Missing a temporary folder. Introduced in PHP 4.3.10 and PHP 5.0.3.
	UPLOAD_ERR_CANT_WRITE	Value: 7; Failed to write file to disk. Introduced in PHP 5.1.0.
	UPLOAD_ERR_EXTENSION	Value: 8; File upload stopped by extension. Introduced in PHP 5.2.0.
	**/
	public $codigo_erro = 0;

	/**
	* Cache para o mtodo sttico arquivos()
	*/
	private static $arquivos = null;

	public static $tipos_permitidos = null;

	/**
	* Constri um Qi_Upload que representa um nico arquivo retirado de $_FILES
	* 
	*/
	function __construct(array &$dados)
	{
		$this->nome 		= $this->_atribuir($dados, "name");
		$this->tipo 		= $this->_atribuir($dados, "type");
		$this->nome_tmp 	= $this->_atribuir($dados, "tmp_name");
		$this->codigo_erro 	= $this->_atribuir($dados, "error");
		$this->tamanho 		= $this->_atribuir($dados, "size");
		$this->extensao		= pathinfo($this->nome, PATHINFO_EXTENSION);
	}

	/**
	* Retorna a mensagem de erro apropriada para o cdigo UPLOAD_ERR_*
	* @TODO traduzir mensagens e melhorar mensagens com dados extrados das configuraes
	*/
	public static function mensagem($codigo_erro)
	{
		if ($codigo_erro == 0) return null;
		$max = 8;
		if ($codigo_erro > $max) throw new LogicException("O cdigo de erro informado [$codigo_erro] deve estar entre 0 e $max");

		$msg[UPLOAD_ERR_INI_SIZE] = // 1
			"The uploaded file exceeds the upload_max_filesize directive in php.ini.";
		$msg[UPLOAD_ERR_FORM_SIZE] = // 2
			"The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form.";
		$msg[UPLOAD_ERR_PARTIAL] = // 3
			"The uploaded file was only partially uploaded.";
		$msg[UPLOAD_ERR_NO_FILE] = // 4
			"No file was uploaded.";
		$msg[UPLOAD_ERR_NO_TMP_DIR] = // 6 Introduced in PHP 4.3.10 and PHP 5.0.3.
			"Missing a temporary folder.";
		$msg[UPLOAD_ERR_CANT_WRITE] = // 7 Introduced in PHP 5.1.0.
			"Failed to write file to disk.";
		$msg[UPLOAD_ERR_EXTENSION] = // 8 Introduced in PHP 5.2.0.
			"File upload stopped by extension.";

		return $msg[$codigo_erro];
	}

	/**
	* retorna apenas as configuraes ini referentes a upload de arquivos
	*/
	public static function ini()
	{
		$ini["file_uploads"] = null; // PHP_INI_SYSTEM
		$ini["open_basedir"] = null; // PHP_INI_SYSTEM
		$ini["post_max_size"] = null; // PHP_INI_PERDIR
		$ini["upload_max_filesize"] = null; // PHP_INI_PERDIR
		$ini["upload_tmp_dir"] = null; // PHP_INI_SYSTEM

		foreach($ini as $nome=>$v):
			$ini[$nome] = ini_get($nome);
		endforeach;

		return $ini;
	}

	/**
	* Retorna um array agrupado por arquivo de Qi_Upload para cada arquivo existente em $_FILES
	*/
	public static function arquivos(array $_files = null)
	{
		if ($_files === null):
			$_files = $_FILES;
			if (isset(self::$arquivos)) return self::$arquivos;
		endif;
		$arquivos = array();
		foreach($_files as $nome => &$dados):
			while(!empty($dados)):
				$arquivos[$nome][] = new Qi_Upload($dados);
			endwhile;
		endforeach;

		return self::$arquivos = $arquivos;
	}

	public static function todos_arquivos()
	{
		$arquivos = self::arquivos();
		$rai = new RecursiveIteratorIterator(new RecursiveArrayIterator($arquivos), RecursiveIteratorIterator::SELF_FIRST);
		$uploads = array();
		foreach($rai as $item)
			if (is_object($item))
				$uploads[] = $item;
		return $uploads;
	}

	public function msg_erro()
	{
		return $this->codigo_erro > 0
				? self::mensagem($this->codigo_erro)
				: false;
	}

	/**
	* Tem algum erro padro de upload
	* A extenso do arquivo  permitida
	*/
	public function tipo_valido($permitidos = null)
	{
		if ($permitidos === null) $permitidos = self::$tipos_permitidos;
		if ($permitidos === null) return true;
		$permitidos = Qi_Util::to_a($permitidos);
		return in_array($this->extensao, $permitidos);
	}

	/**
	* Remove atributo um a um do array $dados (normalmente $dados  o array $_FILES)
	* @param $dados array formatado igual o array global $_FILES
	* @param $atributo string  uma das chaves existentes: name, type, tmp_name, error e size
	* @return string|int atributo
	*/
	private function _atribuir(array &$dados, $atributo)
	{
		// se for array, significa que $_FILES  hierarquico
		if (is_array($dados[$atributo]) ):
			// retira o primeiro
			$valor = array_shift($dados[$atributo]);
			// se no sobrar mais dados, destroy o array para que o mtodo sttico arquivos(),
			// saiba quando parar de procurar por mais arquivos.
			if (empty($dados[$atributo])) 
				unset($dados[$atributo]);
			return $valor;
		endif;

		// se for um arquivo comum, apenas pega o valor e destroy o array para que o mtodo sttico arquivos(),
		// saiba quando parar de procurar por mais arquivos.
		$valor = $dados[$atributo];
		unset($dados[$atributo]);
		return $valor;
	}

	/**
	* Apenas a verso esttica do mtodo salvar aplicada no primeiro arquivo encontrado
	* @TODO o que fazer se no tiver arquivos, ou estiver com erros?
	*/
	public static function salvar_em($dir, $arquivo = null)
	{
		$arquivos = self::arquivos();
		// pega o primeiro arquivo enviado por upload
		$qi_upload = array_shift(array_shift($arquivos));
		return $qi_upload->salvar($dir, $arquivo);
	}

	public static function salvar_todos_em($indice, $dir)
	{
		foreach(self::todos_arquivos() as $arquivo)
			if ($arquivo->codigo_erro == 0 && $arquivo->tipo_valido())
				$arquivo->salvar($dir);
	}

	/**
	* @param $dir string Move o arquivo upload para o diretrio informado
	* @param $arquivo string se informado,  utilizado ao invs de $this->nome,
	* se no tiver extenso, utiliza a extenso original do arquivo
	* @TODO Cria a pasta recursivamente caso no exista
	* Aplica chmod no arquivo para liberar escrita e leitura para terceiros
	*/
	public function salvar($dir, $arquivo = null)
	{
		// se $arquivo existir mas no tiver extenso ...
		if ( $arquivo !== null && pathinfo($arquivo, PATHINFO_EXTENSION) == "" ):
			if ($this->extensao != ""):
				$arquivo .= ".$ext"; // se ele tiver.
			endif;
		else:
			$arquivo = $this->nome;
		endif;

		// verificar se o diretrio de destino existe, caso no, tenta cri-lo recursivamente
		// @TODO tratar algum erro ao tentar criar o diretrio
		if ( ! file_exists($dir) ) 
			mkdir($dir, 0777, true);
		// converter o destino para um nome vlido de arquivo
		$destino = "$dir/$arquivo";
		// verificar se retorna false e usar @ para no gerar warning
		if ( @move_uploaded_file($this->nome_tmp, $destino) === false )
			throw new RuntimeException("No foi possvel salvar [$this->nome_tmp] em [$destino]");
		chmod($destino, 0666);
		return $destino;
	}
}

?>