<?

/**
* Apartir de uma lista de palavras e uma palavra, 
* sugere uma palavra da lista que mais se parece com a palavra informada.
*/
class Qi_Util_Similar
{
	private $lista = array();
	private $palavra = "";

	const SIMILAR = "similar";
	const LEVENSHTEIN = "levenshtein";

	public function __construct(array $lista, $palavra, $metodo = self::SIMILAR)
	{
		$this->lista = array_map("strtolower", $lista);
		
		$this->palavra = strtolower($palavra);
		usort($this->lista, array($this, $metodo));
	}

	/**
	* Mtodo helper sttico
	*/
	public static function sugerir($lista, $palavra, $metodo = self::SIMILAR)
	{
		$sugestor = new Qi_Util_Similar($lista, $palavra, $metodo);
		return $sugestor->sugestao();
	}

	public function sugestao()
	{
		return reset($this->lista);
	}

	public function sugestoes($limit = null)
	{
		if ($limit === null) return $this->lista;
		return array_slice($this->lista, 0, $limit);
	}

	private function similar($a, $b)
	{
		$pa = $pb = 0;
		similar_text($a, $this->palavra, $pa);
		similar_text($b, $this->palavra, $pb);
		if ($pa == $pb) return 0;
		return $pa < $pb ? 1 : -1;
	}

	private function levenshtein($a, $b)
	{
		$pa = $pb = 0;
		$pa = levenshtein($a, $this->palavra);
		$pb = levenshtein($b, $this->palavra);
		if ($pa == $pb) return 0;
		return $pa < $pb ? -1 : 1;
	}
}

?>