<?

/**
* Gera xml/html baseado em uma DSL bem simples.
*/
class Qi_Xml_Builder
{
	private $tag_name = "";
	private $closed = false;
	private $parent = null;
	private $children = array();
	private $attributes = "";
	private $conteudo = "";
	private $ident = 0;

	/**
	* @param $tag_name nome da tag. Informar null para no ter tag, utilizado em contedo de texto puro.
	* @param $attributes string com attributes ou array mapeado
	* @param $conteudo string com da tag em forma de texto, 
			 null para indicar que a tag  fechada, exemplo: <img /> ou <br />
			 Uma instncia da classe Qi_Xml_Builder para reaproveitar contedo previamente gerado, como reutilizar os tr do thead no tfoot
	*/
	public function __construct($tag_name = null, $attributes = "", $conteudo = "", $parent = null, $ident = 0)
	{
		$this->tag_name = htmlspecialchars($tag_name);
		$this->closed = $conteudo === null;

		$this->conteudo = $conteudo instanceof Qi_Xml_Builder
						  ? $conteudo->asXml()
						  : htmlspecialchars($conteudo);
		$this->attributes = is_array($attributes) ? $this->array2attributes($attributes) : $attributes;
		$this->ident = $ident;
	}

	public function __call($tag_name, $args)
	{
		$attributes = count($args) > 0 ? $args[0] : "";
		$conteudo = count($args) > 1 ? $args[1] : "";
		$child = new Qi_Xml_Builder($tag_name, $attributes, $conteudo, $this, $this->ident+1);
		$this->children[] = $child;
		return $child;
	}

	/**
	* @TODO: implementar identao corretamente
	*/
	public function asXml()
	{
		$xml = $this->open_tag();
		$xml .= $this->conteudo;
		if (!empty($this->children))
			$xml .= "\n".$this->children2xml()."\n";
		$xml .= $this->close_tag();
		$xml = str_replace("\n", "\n".str_repeat(" ", $this->ident), $xml);
		return $xml;
	}

	private function children2xml()
	{
		$xml = "";
		foreach($this->children as $child)
			$xml .= $child->asXml();
		return $xml;
	}

	private function open_tag()
	{
		if (!$this->tag_name) return "";
		$tag = "<$this->tag_name";
		if ($this->attributes) $tag .= " $this->attributes";
		if ($this->closed) $tag .= " /";
		$tag .= ">";
		return $tag;
	}

	private function close_tag()
	{
		if (!$this->tag_name) return "";
		return $this->closed ? "" : "</$this->tag_name>\n";
	}

	private function array2attributes($array)
	{
		$attributes = array();
		foreach($array as $k=>$v):
			$k = htmlspecialchars($k);
			$v = htmlspecialchars($v);
			$attributes[] = "$k=\"$v\"";
		endforeach;
		return implode(" ", $attributes);
	}
}

?>