(function ($, window, document) {
    'use strict';
    window.App = {
        template: {}
    };

    $(function () {
        App.template.loadBanner();
        App.apresentacao.init();

        $('[data-fancybox="gallery"]').trigger('click');
        
        if ('solucoes' == App.template.currentPage) {
            $('.scroll').on('click', function (e) {
                e.preventDefault();
                $('html, body').animate({
                    scrollTop: $($(this).data('scroll')).offset().top
                }, 500);
            });
        }

        if ('contato' == App.template.currentPage) {
            App.contato.init();
        }
    });

    App.template = {
        url: '//okea.com.br/',
        currentPage: location.pathname.substring(1).split('/')[0],
        loadBanner: function () {
            imagesLoaded('body', function (instance) {
                App.template.loadPage();
            });
        },
        loadPage: function () {
            $('body').animate({
                opacity: 1
            }, 1000);
        }
    };

    App.apresentacao = {
        timerStatus: null,
        pathArquivo: App.template.url + "envia_email_apresentacao.php",
        setMasks: function () {
            $('.cnpj').mask("99.999.999/9999-99");
            $('.phone').focusout(function () {
                var phone, element;
                element = $(this);
                element.unmask();
                phone = element.val().replace(/\D/g, '');
                if (phone.length > 10) {
                    element.mask("(99)99999-999?9");
                } else {
                    element.mask("(99)9999-9999?9");
                }
            }).trigger('focusout');
        },
        fadeStatus: function () {
            if (App.apresentacao.timerStatus !== null) {
                $('.status').stop().fadeOut(500);
                App.apresentacao.timerStatus = null;
            }
        },
        send: function () {
            var _element = '#formApresentacao';
            var _dados = $(_element).serialize();
            $(_element).find('input').attr('disabled', 'disabled').css('opacity', '0.7');
            $('.status').html('Enviando dados...').stop().fadeIn(500);

            $.ajax({
                type: "POST",
                url: App.apresentacao.pathArquivo,
                dataType: 'json',
                data: _dados,
                success: function (data) {
                    if (data.result == true) {
                        $('.status').html(data.message).stop().fadeIn(500);
                        $(_element).find('input').removeAttr('disabled').css('opacity', '1');
                        $(_element).reset();
                        //grecaptcha.reset();

                        if (data.redirect != undefined) {
                            App.apresentacao.timerStatus = setTimeout(function () {
                                App.apresentacao.fadeStatus();
                                window.location.href = App.template.url + data.redirect;
                            }, 3000);
                        } else {
                            App.apresentacao.timerStatus = setTimeout(App.apresentacao.fadeStatus, 3000);
                        }
                    } else {
                        $('.status').html(data.message).stop().fadeIn(500);
                        $(_element).find('input').removeAttr('disabled').css('opacity', '1');
                        //grecaptcha.reset();

                        if (data.redirect != undefined) {
                            App.apresentacao.timerStatus = setTimeout(function () {
                                App.apresentacao.fadeStatus();
                                window.location.href = App.template.url + data.redirect;
                            }, 3000);
                        } else {
                            App.apresentacao.timerStatus = setTimeout(App.apresentacao.fadeStatus, 3000);
                        }
                    }
                }
            });
        },
        init: function () {
            App.apresentacao.setMasks();

            $("#formApresentacao").on('submit', function (e) {
                e.preventDefault();
                App.apresentacao.send();
            });
        }
    };

    App.contato = {
        timerStatus: null,
        pathArquivo: App.template.url + "envia_email_contato.php",
        setMasks: function () {
            $('.cnpj').mask("99.999.999/9999-99");
            $('.phone').focusout(function () {
                var phone, element;
                element = $(this);
                element.unmask();
                phone = element.val().replace(/\D/g, '');
                if (phone.length > 10) {
                    element.mask("(99)99999-999?9");
                } else {
                    element.mask("(99)9999-9999?9");
                }
            }).trigger('focusout');
        },
        fadeStatus: function () {
            if (App.contato.timerStatus !== null) {
                $('.status').stop().fadeOut(500);
                App.contato.timerStatus = null;
            }
        },
        send: function () {
            var _element = '#formContato';
            var _dados = $(_element).serialize();
            $(_element).find('input').attr('disabled', 'disabled').css('opacity', '0.7');
            $('.status').html('Enviando mensagem...').stop().fadeIn(500);

            $.ajax({
                type: "POST",
                url: App.contato.pathArquivo,
                dataType: 'json',
                data: _dados,
                success: function (data) {
                    if (data.result == true) {
                        $('.status').html(data.message).stop().fadeIn(500);
                        $(_element).find('input').removeAttr('disabled').css('opacity', '1');
                        $(_element).reset();
                        //grecaptcha.reset();

                        if (data.redirect != undefined) {
                            App.contato.timerStatus = setTimeout(function () {
                                App.contato.fadeStatus();
                                window.location.href = App.template.url + data.redirect;
                            }, 3000);
                        } else {
                            App.contato.timerStatus = setTimeout(App.contato.fadeStatus, 3000);
                        }
                    } else {
                        $('.status').html(data.message).stop().fadeIn(500);
                        $(_element).find('input').removeAttr('disabled').css('opacity', '1');
                        //grecaptcha.reset();

                        if (data.redirect != undefined) {
                            App.contato.timerStatus = setTimeout(function () {
                                App.contato.fadeStatus();
                                window.location.href = App.template.url + data.redirect;
                            }, 3000);
                        } else {
                            App.contato.timerStatus = setTimeout(App.contato.fadeStatus, 3000);
                        }
                    }
                }
            });
        },
        init: function () {
            App.contato.setMasks();

            $("#formContato").on('submit', function (e) {
                e.preventDefault();
                App.contato.send();
            });
        }
    };

}(window.jQuery, window, document));