<?

/**
* Exibe valores em bytes formatados.
*/
class Qi_Bytes
{
	/**
	* Arredonda um nmero de forma inteligente:
	* 0 = 0 (o nico valor 0  o prprio zero)
	* 0.000123 = 0.001 (no arredonda para zero, e sim para cima)
	* 1000/1024 = 1 (No 1.0)
	* 2.36 = 2.4 (1 casa decimal se for menor de 10)
	* 10.6 = 11 (sem casas decimais para nmeros maiores que 10)
	*/
	public static function round($n)
	{
		if ($n == 0): 
			$decimais = 0;
		else:
			$n = round($n, 3);
			if ($n < 0.001):
				// numeros com mais de 3 casas decimais,
				// mas maiores que zero, so arredondados para 0.001
				$n = 0.001;
				$decimais = 3;
				elseif ($n < 0.01):
					$decimais = 3;
				elseif (round($n, 2) < 0.1):
					$decimais = 2;
				elseif (round($n, 1) < 1):
					$decimais = 1;
				elseif (round($n) == round($n, 1)):
					$decimais = 0;
				elseif ($n < 10):
					$decimais = 1;
				else:
					$decimais = 0;
			endif;
		endif;

		// mostrar separador de milhar, apenas apartir de 1 milho.
		$milhao = $n < 1000 * 1000 ? "" : ".";
		$f = number_format($n, $decimais, ".", $milhao);
		return $f;
	}

	/**
	* Baseado no valor em bytes, decide qual melhor unidade utilizar: KB, MB ou GB
	*/
	public static function format($n)
	{
		if ($n < 1000*1000) return self::KB($n);
		if ($n < 1000*1000*1000) return self::MB($n);
		return self::GB($n);
	}

	public static function bytes($n)
	{
		$f = self::round($n);
		return "$f b";
	}

	public static function KB($n)
	{
		$f = self::round($n/1024);
		return "$f KB";
	}

	public static function MB($n)
	{
		$f = self::round($n/1024/1024);
		return "$f MB";
	}

	public static function GB($n)
	{
		$f = self::round($n/1024/1024/1024);
		return "$f GB";
	}
}

?>