<?

if (!extension_loaded('mcrypt'))
	throw new Exception("Qi_Cript depende da extension 'mcrypt'.");

/**
 * @TODO verificar se a extenso mcrypt est instalada
**/

class Qi_Cript
{
	/**
	 * Esta funo  compatvel com a funo aes_encrypt/aes_decrypt do MySql (usar HEX e UNHEX)
	 * @param $chave string deve ter no mximo 16 caracteres
	 * se $chave no for informado, uma chave ser gerada e imbutidade na string de retorno,
	 * a funo decrypt conseguir identificar esta string e extrair a chave para descriptografar o texto.
	 * O retorno  uma string upcase com 32 caracteres: cript("a", "1") = A00852AAA8D86D59C35AA81C96236DD9
	 * Caso a chave no seja informada, a string ter:
	 *	32 caracteres + 16 caracteres da chave + 1 caracter separador = 48 caracteres.
	 * Se o texto_secreto tiver 16 caracteres ou mais, o retorno ter ento 64 caracteres.
	 * 32 ou mais, ter 96 caracteres
	 * 48 ou mais, ter 128 e assim por diante, assim:
	 * 00-15 = 32
	 * 16-31 = 64
	 * 32-47 = 96
	 * 48-63 = 128
	 * 64-79 = 160 (a cada 16, soma 32)
	**/
	public static function cript($texto_secreto, $chave = null)
	{
		self::_validar_chave($chave);
		$separador = null;
		if ($chave === null):
			$chave = strtoupper(self::gerar_chave(16, $texto_secreto));
			$separador = "O";
		endif;

		$length = strlen($texto_secreto);
		$pad_length = 16 * (floor($length / 16.0)+1);
		$pad_string = chr(16-($length % 16));
		$texto_secreto = str_pad($texto_secreto, $pad_length, $pad_string);

		$return = self::_mcrypt_crypt("en", $chave, $texto_secreto);

		$return = strtoupper(bin2hex($return));
		if ($separador !== null) $return = str_rot13(strrev($return.$separador.$chave));
		return $return;
	}

	/**
	* Se $chave no for informado, deduz que a chave est embutidade no $texto_criptografado,
	* atravs da tcnica utilizada na funo cript acima
	*/
	public static function decript($texto_criptografado, $chave = null)
	{
		self::_validar_chave($chave);
		if ($chave === null):
			$texto_criptografado = strrev(str_rot13($texto_criptografado));
			list($texto_criptografado, $chave) = explode("O", $texto_criptografado, 2);
		endif;

		$val = pack("H*", $texto_criptografado);

		$dec = self::_mcrypt_crypt("de", $chave, $val);

		$ultimo_char = substr($dec, -1);
		$ord_ultimo_char = ord($ultimo_char);
		$pad_diferente_null = $ord_ultimo_char >= 0 && $ord_ultimo_char <= 16;
		$padding_char =  $pad_diferente_null ? chr($ord_ultimo_char) : null;
		$return = rtrim($dec, $padding_char);

		return $return;
	}

	/**
	* gera uma string randmica com exatamente o tamanho mximo especificado.
	* @param $args pode ser informado vrias vezes e serve como uma string para ser adicionada a chave,
	* mas ainda de forma randmica.
	*/
	public static function gerar_chave($tamanho_maximo = 16, $args = "")
	{
		list($micro) = explode(" ", microtime());
		$micro = substr($micro, 2, 6);
		$rand = mt_rand();
		$args = func_get_args(); // $args pode ser informado mais de uma vez
		array_shift($args); // retira $tamanho_maximo
		$args = implode("", $args); // junta todos $args
		$chave = "$micro$rand$args";
		$chave = str_shuffle($chave);
		$chave = base64_encode($chave);
		return substr($chave, 0, $tamanho_maximo);
	}

	/**
	* A chave no pode ter mais que 16 caracteres
	* @TODO disparar exception ou apenas truncar a chave em 16?
	*/
	private static function _validar_chave($chave)
	{
		$tamanho_chave = strlen($chave);
		if ($tamanho_chave > 16) throw new LengthException("A chave no pode ter mais que 16 caracteres ($tamanho_chave)[$chave]");
	}

	private static function _mcrypt_crypt($sufixo, $chave, $valor)
	{
		$mode = MCRYPT_MODE_ECB; 
		$enc = MCRYPT_RIJNDAEL_128;
		$iv_size = mcrypt_get_iv_size($enc, $mode);
		$random = Qi_Util::eh_windows() ? MCRYPT_RAND : MCRYPT_DEV_URANDOM;
		$iv = mcrypt_create_iv( $iv_size, $random);

		$function = "mcrypt_{$sufixo}crypt";
		return $function($enc, $chave, $valor, $mode, $iv);
	}
}

?>