<?

/**
Esta classe funciona apenas com MySql. Deixar para o PDO o acesso multibanco
Op��o pelos m�todos static para n�o ser necess�rio ficar passando o objeto banco como par�metro para m�todos,
podendo ser usado globalmente em qualquer lugar.

@TODO Criar uma maneira de manter a senha criptografada no arquivo fonte PHP
@TODO Separar o c�digo que gera a SQL, do que executa, 
para facilitar a cria��o de testes sem que seja preciso conectar-se no banco.
*/
class Qi_Db
{
	/**
	* @type mysql resource
	* Mant�m internamente o link de conex�o com o banco,
	* caso precise usar esta classe com outro link, basta escrever nesta vari�vel.
	* Todas opera��es internas da classe s�o executadas usando este link.
	*/
	public static $link = null;

	/**
	* @type array
	* Mantem um hist�rico de todas as querys executadas pela classe no formato:
	* [microtime_de_inicio] => array(duracao_ms, duracao_segundos, query)
	*/
	public static $historico_query = array();

	/**
	* Guarda a �ltima query executada, para ser exibida caso algum erro ocorra e
	* tamb�m para ser inserida no array de historico, quando pausar o cron�metro.
	*/
	public static $ultima_query = "";

	/**
	* Cont�m o resultado da �ltima query executada, como um resource do tipo 'mysql result'
	*/
	public static $result = null;

	/**
	* Quando a query for de consulta, armazena a quantidade de resultados retornados,
	* Quando a query for de altera��o, cont�m a quantidade de registros afetados.
	*/
	public static $num_linhas = null;

	/**
	* Vari�vel interna para controlar o in�cio do cron�metro.
	*/
	private static $_tempo_inicial = null;

	/**
	* Faz cache dos dados das colunas das tabelas, para n�o precisar perguntar novamente.
	* @TODO implementar o cache separado por conex�o, j� que esta classe � static.
	*/
	private static $_cache_tabelas_colunas = array();

	/**
	* Estabelece uma conex�o com o banco de dados mysql e mant�m at� o fim do script,
	* portanto esta fun��o deve ser chamada apenas uma �nica vez em toda a vida do script,
	* normalmente no come�o, fazendo require_once para um arquivo conexao.php, �nico para todo o site.
	* @param $host pode ser um array mapeado com os mesmos parametros da fun��o
	**/
	public static function conectar($host = "localhost",
									$usuario = "root",
									$senha = "",
									$banco = null,
									$persistente = true)
	{
		if ( ! extension_loaded("mysql") )
			throw new Exception("A extens�o [mysql] n�o foi carregada! Verifique o php.ini");

		self::_inicia_cronometro();

		$default = array (
			'host'			=> 'localhost',
			'usuario'		=> 'root',
			'senha'			=> '',
			'banco'			=> null,
			'persistente'	=> true
		);

		if(is_array($host))
			$conf = $host;
		else
			$conf = compact(array_keys($default)); // cria um array com os par�metros da fun��o

		$conf = array_merge($default, $conf); // junta as configura��es padr�es com as informadas
		extract($conf);

		$function = $persistente ? 'mysql_pconnect' : 'mysql_connect';
		self::$ultima_query = "$function('$host', '$usuario', '*senha_ocultada*', '$banco')";

		self::$link = @$function($host, $usuario, $senha); // suprime erro padr�o para usar Exception abaixo
		if (self::$link === false) 
			throw new Exception("N�o foi poss�vel conectar " . self::$ultima_query . ": " . mysql_error());

		if ($banco) self::selecionar_banco($banco);

		self::_pausa_cronometro();

		return self::$link;
	}

	/**
	* Lista os bancos de dados dispon�veis para a conex�o atual
	*/
	public static function bancos()
	{
		$result = self::$link ? mysql_list_dbs(self::$link)
							  : mysql_list_dbs();
		$lista = array();
		while ($row = mysql_fetch_object($result))
			$lista[$row->Database] = $row->Database;
		return $lista;
	}

	/**
	* Seleciona o banco padr�o que ser� utilizado pela classe
	* @TODO caso n�o consiga selecionar, exibir na mensagem de erro, quais os bancos que o usu�rio tem acesso.
	*/
	public static function selecionar_banco($banco)
	{
		if(mysql_select_db($banco, self::$link) === false):
			// precisa gerar exception pois select_db n�o gera warning
			$bancos = self::bancos();
			$sugestao = Qi_Util_Similar::sugerir($bancos, $banco);
			$bancos = implode("\n", $bancos);
			throw new DomainException("banco [$banco] inexistente ou sem permiss�o de acesso.
voc� n�o quis dizer [$sugestao]?
Seu usu�rio tem acesso aos seguintes bancos:

$bancos
");
		endif;
	}

	/**
	* Faz um valor ser v�lido para utilizar em uma sql
	*/
	public static function escape($valor)
	{
		return self::$link ? mysql_real_escape_string($valor, self::$link)
						   : mysql_real_escape_string($valor);
	}

	/**
	* Executa uma query qualquer, tanto de select como insert, update, delete, show, drop, etc.
	*/
	public static function query($sql)
	{
		self::$ultima_query = $sql;
		self::_inicia_cronometro();

		if (self::$link === null) // o link � null, quando a conex�o foi feita fora da classe
			$result = self::$result = mysql_query($sql);
		else
			$result = self::$result = mysql_query($sql, self::$link);

		self::_pausa_cronometro();

		if($result === false):
			throw new Exception( "\n[$sql]\n". (self::$link ? mysql_error(self::$link) : mysql_error()) );
		else:
			if ($result === true): // n�o foi executado um select e sim uma query que altera
				return self::$num_linhas = self::$link ? mysql_affected_rows(self::$link) : mysql_affected_rows();
			else:
				self::$num_linhas = mysql_num_rows($result);
				return new Qi_It_MySql($result);
			endif;
		endif;
	}

	/**
	* @param $extra string pode ser um WHERE, JOIN ou qualquer c�digo que ser� adicionado no SELECT
	* Se $extra for array, converte para WHERE
	* @return int a quantida de elementos na tabela
	*/
	public static function count($tabela, $extra = "")
	{
		if (is_array($extra)) $extra = Qi_Db_Sql::add_where($extra);
		return (int)self::query("SELECT count(*) FROM $tabela $extra")->valor();
	}

	/**
	* Retorna o �ltimo ID gerado por um comando INSERT
	*/
	public static function ultimo_id_gerado()
	{
		return self::$link ? mysql_insert_id(self::$link) : mysql_insert_id();
	}

	/**
	* select para facilitar par�metros para o select, como order, limit, etc
	* fazer na classe Qi_Db_Sql
	*/
	public static function select($tabela, array $conf = array())
	{
		$sql = Qi_Db_Sql::select($tabela, $conf);
		return self::query($sql);
	}

	/**
	* retorna um �nico registro filtrando pelo seu ID
	*/
	public static function get($tabela, $id)
	{
		$sql = Qi_Db_Sql::select($tabela, array("WHERE" => array("id" => $id)));
		return self::query($sql);
	}

	/**
	* Procura um registro com as caracter�sticas em $dados e retorna seu id, caso contr�rio cria o registro e retorna o id
	*/
	public static function find_or_create($tabela, $dados, $campo_id = "id")
	{
		$registros = self::select($tabela, $dados);
		if (count($registros) == 0)
			return self::insert($tabela, $dados);
		else
			return $registros[$campo_id]; // se encontrar v�rios, retorna o id apenas do primeiro
	}

	/**
	* Dado o nome da tabela e um array mapeado com os dados, faz uma inser��o no banco
	*/
	public static function insert($tabela, $dados)
	{
		$sql = "INSERT INTO $tabela SET\n";
		$dados = self::_filtrar_colunas_inexistentes($tabela, $dados);
		self::query($sql . Qi_Db_Sql::gerar_set($dados));
		return self::ultimo_id_gerado();
	}

	/**
	* @important N�O faz mais o REPLACE do mysql, ou seja:
	* executa um insert caso o id n�o exista ou n�o seja informado,
	* executa um DELETE seguido de um INSERT caso o id exista
	*
	* Se $on_duplicate_key for informado com uma string como: cont = cont + 1
	* ou array("cont" => array("cont + 1")),
	* ele executa um INSERT com ON DUPLICATE KEY UPDATE cont = cont + 1
	* usado para atualizar um valor caso o registro j� exista
	* Evitar usar em tabelas com v�rios UNIQUES INDEX (ver manual MySql)
	*
	* @important O REPLACE INSERE NULL NOS DADOS EXISTENTES QUE N�O FORAM INFORMADOS
	* @TODO renomear este metodo para replace e implementar um novo que,
	* verifica no banco se a chave existe, para decidir se ser� executado um insert ou update,
	* assim n�o ter� o comportamento perigoso do REPLACE
	*/
	public static function salvar($tabela, $dados, $on_duplicate_key = null)
	{
		$dados = self::_filtrar_colunas_inexistentes($tabela, $dados);
		$set = Qi_Db_Sql::gerar_set($dados);
		$on_duplicate_key = $on_duplicate_key === null ? $set : Qi_Db_Sql::gerar_set($on_duplicate_key);
		$sql = "INSERT INTO $tabela SET\n";
		$sql .= $set;
		$sql .= "\nON DUPLICATE KEY UPDATE\n";
		$sql .= $on_duplicate_key;
		self::query($sql);
		return (self::ultimo_id_gerado())?self::ultimo_id_gerado():true;
	}

	/**
	* Dado o nome da tabela, um array mapeado com os dados e um filtro opicional, faz um update no banco
	*/
	public static function update($tabela, $dados, $where = "")
	{
		$dados = self::_filtrar_colunas_inexistentes($tabela, $dados);
		$sql = "\nUPDATE $tabela SET\n\n";
		$sql .= Qi_Db_Sql::gerar_set($dados);
		$where = Qi_Db_Sql::add_where($where);
		$sql .= "\n\n$where";
		return self::query($sql);
	}

	/**
	* Exclui linhas da tabela $tabela, baseado no where
	*/
	public static function delete($tabela, $where = "")
	{
		$where = Qi_Db_Sql::add_where($where);
		$sql = "DELETE FROM $tabela $where";
		return self::query($sql);
	}

	/**
	* @return array apenas com os dados das colunas existentes no banco.
	* Utilizado em Insert, Update e Salvar para permitir apenas colunas existentes na tabela.
	*/
	static function _filtrar_colunas_inexistentes($tabela, $dados)
	{
		$dados = Qi_Util::to_a($dados);
		$colunas = self::_colunas_da_tabela($tabela);
		return array_intersect_key($dados, $colunas);
	}

	/**
	* @return array a chave � o nome da coluna
	*/
	static function _colunas_da_tabela($tabela)
	{
		return isset(self::$_cache_tabelas_colunas[$tabela])
			   ? self::$_cache_tabelas_colunas[$tabela]
			   : self::$_cache_tabelas_colunas[$tabela] 
			   = iterator_to_array(
					new Qi_It_ChaveValor(Qi_Db::query("SHOW FULL COLUMNS FROM $tabela"), "Field", "Field")
				);
	}

	/**
	* Dispara uma exception caso $resource n�o seja um resource mysql v�lido
	*/
	public static function try_mysql_resource($resource)
	{
		if (!is_resource($resource))
			throw new Exception("
n�o � um resource mysql v�lido.
\$resource = ".var_export($resource, true));

		if ( ($_ = get_resource_type($resource)) != "mysql result" )
			throw new Exception("O resource n�o � do tipo 'mysql result' e sim '$_'");
	}

// m�todos privados

	/**
	 * Toda sql executada � gravado seu tempo de execu��o no array: $historico_query
	 */
	private static function _inicia_cronometro()
	{
		self::$_tempo_inicial = microtime(true);
	}

	/**
	* Pausa o cron�metro e adiciona a "duracao" e a "query" executada no array: $historico_query
	* A chave do array indica a data em que a query foi executada (em microtime)
	*/
	private static function _pausa_cronometro()
	{
		$duracao_ultima_query = microtime(true) - self::$_tempo_inicial;
		self::$historico_query[sprintf("%01.5f", self::$_tempo_inicial)] = array(
			"duracao_ms" => round($duracao_ultima_query * 1000, 1),
			"duracao_segundos" => sprintf("%01.4f", $duracao_ultima_query),
			"query" => self::$ultima_query
		);
	}
}

?>