<?

/**
* Esta classe encapsula as definies de uma tabela MySql
* @TODO talvez migrar esta classe para Qi_Html_*
*/
class Qi_Db_Def_Tabela
{
	/**
	* Lista de colunas do tipo: Qi_Db_Def_Coluna
	*/
	private $colunas = array();

	/**
	* Nome da tabela
	*/
	public $nome = "";

	/**
	* Constri extraindo informaes da tabela $nome_tabela
	*/
	public function __construct($nome_tabela)
	{
		$this->nome = $nome_tabela;
	}

	public function getColunas()
	{
		$colunas = Qi_Db::query("SHOW FULL COLUMNS FROM $this->nome");

		foreach($colunas as $linha):
			$this->colunas[$linha["Field"]] = new Qi_Db_Def_Coluna($linha);
		endforeach;
		
		return $this->colunas;
	}

	/**
	* @param $nome_tabela string Nome da tabela no banco
	* @param $dados array Dados para preencher os campos no formulrio,
	* no formato campo => valor
	* @param $ignorar array Lista de campos para no gerar no formulrio
	*/
	public static function gerar_campos($nome_tabela, array $dados = array(), $ignorar = array())
	{
		$def_tabela = new Qi_Db_Def_Tabela($nome_tabela);
		$ignorar = Qi_Util::to_a($ignorar);
		$trs = "";
		foreach($def_tabela->getColunas() as $nome => $coluna):
			if ($coluna->eh_auto_increment) continue;
			if ( in_array($nome, $ignorar) ) continue;
			$trs .= $coluna->gerar_html(@$dados[$nome]);
		endforeach;
		return $trs;
	}
}

?>