<?

/**
* Auxilia na criao de comandos SQL, como update, insert, delete, where, etc.
*/
class Qi_Db_Sql
{
	public static $padrao = array (
		"SELECT" 	=> "SQL_CACHE *",
		"FROM" 		=> null,
		"LEFT JOIN" => null, // "produtos",
		"ON" 		=> null, // "produto_id = produtos.id",
		"USING" 	=> null, // "(id)",
		"WHERE" 	=> null,
		"GROUP BY" 	=> null, // "id",
		"HAVING" 	=> null, // "count > 10",
		"ORDER BY" 	=> null, // "criado_em DESC",
		"LIMIT" 	=> null, // "0, 10"
	);
	/**
	* Apartir dos pares campo => valor, gera uma string para ser usada no SET:
	* array("nome" => "Marco's", idade => 27) vira a string
	* 	nome = "Marco\'s",
	*	idade = 27
	* @return string
	*/
	public static function gerar_set($dados)
	{
		$set = self::campo_valor($dados);
		return join(",\n\t", $set);
	}

	/**
	* Constri uma SQL completa, apartir das configuraes informadas.
	* @param $tabela Pode ser o nome da tabela, 
	* ou um array no formato da varivel $padrao interna.
	* @TODO ao inves de procurar pelo campo id, descobrir qual a chave primaria da tabela
	* @param $conf se for um inteiro, procura por um id com aquele valor
	* se for um array no formato array("idade" => 22, "nome" => "neves"), 
	*  utilizado para construir o WHERE.
	* Por ltimo, faz interseco com os campos da varivel interna $padrao (tudo maisculo)
	*/
	public static function select($tabela, $conf = array())
	{
		 // caso a query inteira seja gerada por um array de configurao
		if (is_array($tabela)) $conf = $tabela;
		// facilita o uso de select por id, 
		// por exemplo, para selecionar o usuario com id 2, faa: Qi_Db::select("usuarios", 2)
		elseif (is_int($conf)) $conf = array("id" => $conf);

		$padrao = self::$padrao;
		$padrao["FROM"] = is_array($tabela) ? null : $tabela; // $tabela foi passado como um array completo de configurao
		// apenas as configuraes que no so padres(where)
		$where = array_diff_key($conf, $padrao);
		// configuraes sem o where acima
		$conf = array_diff_key($conf, $where);
		$conf = array_merge($padrao, $conf);

		if (isset($conf["WHERE"])):
			$conf["WHERE"] = array_merge($conf["WHERE"], $where);
		else:
			$conf["WHERE"] = $where;
		endif;

		//var_dump($conf);
		/* se no existir no array nenhum padro,  considerado como WHERE
		$intersect = array_intersect_key($padrao, $conf);
		if ( empty($intersect) && !empty($conf) )
			$conf = array("WHERE" => $conf);

		$conf = array_change_key_case($conf, CASE_UPPER);
		$conf = array_merge($padrao, $conf);
		*/
		return self::array2sql($conf);
	}

	/**
	* dado um array com a chave sendo as partes do SQL, constroi uma string SQL vlida.
	* O array informado deve j ter os dados prontos para gerar o sql, 
	* pois no recebero scape ou tratamento especial como null, false, numrico, etc.
	* Salvo o WHERE, que  tratado pelo add_where
	*/
	public static function array2sql($conf)
	{
		$sql = array();

		foreach(self::$padrao as $k => $v):
			$v = @$conf[$k];
			if (isset($v) && !empty($v)): // ignora as configuraes nulas (pois todos os valorse devem ser string ou array
				$sql[$k] = $k == "WHERE" // tratamento especial para WHERE, aceita string ou outro array mapeado,
							? trim(Qi_Db_Sql::add_where($v)) // deve existir apenas 1 WHERE
							: "$k $v"; // para os outros, apenas concatena com espao
			endif;
		endforeach;

		$sql = implode("\n\t", $sql); // indenta os tens do array em cada linha com TAB no comeo
		return $sql; // sql j na forma de string e pronta para execuo
	}
	/**
	* Retorna o valor formatado de acordo com seu tipo:
	* string retorna "string" com aspas e quote quando necessrio
	* null retorna "NULL"
	* false e true retornam "false" e "true"
	* Caso $valor seja um objeto, chama __toString
	*/
	public static function formatar_por_tipo($valor)
	{
		if (is_numeric($valor)):
			// se a verso numerica for exatamente igual a string,
			// retorna como numero, caso contrario, como string.
			// assim permite a insero de cpf/cnpj em campos string
			// mantendo os zero  esquerda.
			$val = floatval($valor);
			$val = strval($val);
			return $val === strval($valor) ? $valor : "\"$valor\"";

		elseif(is_string($valor)):
			$valor = Qi_Db::escape($valor);
			return "\"$valor\"";

		elseif(is_null($valor)):
			return "NULL";

		elseif(is_bool($valor)):
			return $valor ? "true" : "false";

		elseif(is_array($valor)):
			return implode(",", $valor);

		elseif(is_object($valor) && method_exists($valor, "__toString")):
			return (string)$valor; // caso seja objeto, ir chamar __toString
		endif;
		$tipo = gettype($valor);
		throw new Exception("Valor [$valor] do tipo $tipo no pode ser formatado");
	}

	/**
	* Converte um array no formato: array("nome" => "Marcos's", idade => 27) em
	* array("nome" => "nome = "Marco\'s"", "idade" => "idade = 27")
	* @param $alteracao bool Se true, no utiliza IN em valores de array:
	*	ids = "1,2,3"
	* se false, utiliza IN e coloca os elementos do array entre parnteses:
	*	ids IN (1,2,3)
	* se o array for vazio, em ambos os casos  utlizado NULL,
	* pois NULL nunca retorna true quando comparado com algo
	* Um parmetro array  usado para atribuir um valor sem quote, exemplo:
	* array("criado_em" => array("now()")) fica com o now() sem aspas:
	* array("criado_em" => "criado_em = now()")
	*/
	static function campo_valor($dados, $alteracao = true)
	{
		$set = array();
		foreach($dados as $coluna => $valor):
			 // indice numerico, passa direto o $valor, como: email like '%@gmail.com%'
			if (is_numeric($coluna)):
				$set[] = $valor;
				continue;
			endif;
			$op = "=";
			if(is_array($valor)):
				switch(count($valor)):
					case 0:
						$valor = "NULL";
						if (!$alteracao) $op = "IS";
					break;
					// @FIXME: sem o formatar_por_tipo, no  possvel inserir "palavra com aspas" e now() sem aspas ao mesmo tempo
					// utilizar Qi_Db_Unescape("now()") ou o atalho u para conseguir o mesmo efeito
					case 1: $valor = self::formatar_por_tipo(reset($valor)); break;
					default:
						$valor = implode(",", $valor);
						if ($alteracao):
							$valor = "\"$valor\"";
						else:
							$valor = "($valor)";
							$op = "IN";
						endif;
				endswitch;
			else:
				if (is_null($valor) && !$alteracao) $op = "IS";
				$valor = self::formatar_por_tipo($valor);
			endif;
			$set[$coluna] = "$coluna $op $valor";
		endforeach;
		return $set;
	}

	/**
	* Criar string WHERE apartir de um array mapeado, concatenando as partes com:
	* $boolean por padro AND, mas pode ser OR
	*/
	public static function array2where(array $array, $boolean = "AND")
	{
		return join("\n\t$boolean ", self::campo_valor($array, false));
	}

	/**
	* Adiciona where no comeo da string caso ela no o tenha:
	* 'nome = "neves"' fica ' WHERE nome = "neves"'
	* caso seja array, converte primeiro para string, usando campo_valor()
	*/
	static function add_where($where)
	{
		if ( is_array($where) )
			$where = self::array2where($where);

		$where = trim($where);

		if ($where === "")
			return $where; // ignora strings vazias

		if (preg_match("/^\s*where\s+/i", $where) === 0)
			$where = "WHERE $where";

		return " $where"; // precisa retornar o espao no comeo, para facilitar concatenao
	}
}

?>