<?

/**
 * Toda operao com arquivo depende dele existir, do diretrio existir, e de ambos terem permisso.
 * Criar uma rotina e uma exceo para abordar esta necessidade.
 * @TODO  comum precisar testar se um arquivo/diretorio tem permisso de escrita para o PHP.
 * criar uma rotida que dado um nome de arquivo, dispara uma exceo caso no satisfaa a condio acima,
 * e mostre na mensagem informaes detalhadas do arquivo como quem  o dono, grupo e permisses.
**/

class Qi_File
{
	/**
	 * Dado um arquivo ou diretrio, retorna a sua permisso no formato octal: 0666, 0755, etc
	 * @important No  o valor inteiro, e sim a verso string do valor inteiro em octal. 
	 * Se quiser o valor inteiro, use a funo interna fileperms do PHP.
	**/
	public static function permissao_octal($dir_file)
	{
		return substr(sprintf('%o', fileperms($dir_file)), -4);
	}

	/**
	 * Dado um arquivo, diretrio ou um inteiro, retorna a sua permisso no formato texto: dr-xr-----, -rw-r--r--, etc
	**/
	public static function permissao_texto($dir_file_int)
	{
		$perms = is_string($dir_file_int) ? fileperms($dir_file_int) : $dir_file_int;
		$tipo = $perms & 0xF000; // utiliza apenas o hexadecimal de maior valor
		$tipos[0xC000] = "s";// Socket
		$tipos[0xA000] = "l";// Symbolic Link
		$tipos[0x8000] = "-";// Regular
		$tipos[0x6000] = "b";// Block special
		$tipos[0x4000] = "d";// Directory
		$tipos[0x2000] = "c";// Character special
		$tipos[0x1000] = "p";// FIFO pipe
		$info = isset($tipos[$tipo]) ? $tipos[$tipo] : 'u';// Unknown

		// Owner
		$info .= $perms & 0x0100 ? 'r' : '-';
		$info .= $perms & 0x0080 ? 'w' : '-';
		$info .= ($perms & 0x0040 ?
		           (($perms & 0x0800) ? 's' : 'x' ) :
		           (($perms & 0x0800) ? 'S' : '-'));

		// Group
		$info .= $perms & 0x0020 ? 'r' : '-';
		$info .= $perms & 0x0010 ? 'w' : '-';
		$info .= ($perms & 0x0008 ?
		           (($perms & 0x0400) ? 's' : 'x' ) :
		           (($perms & 0x0400) ? 'S' : '-'));

		// Others
		$info .= $perms & 0x0004 ? 'r' : '-';
		$info .= $perms & 0x0002 ? 'w' : '-';
		$info .= (($perms & 0x0001) ?
		           (($perms & 0x0200) ? 't' : 'x' ) :
		           (($perms & 0x0200) ? 'T' : '-'));
		return $info;
	}

	/**
	* Verifica se a string informada representa um nome de arquivo|diretrio
	* Usado apenas para diferenciar um texto complexo de um caminho de arquivo
	* @return bool
	*/
	public static function string_eh_arquivo($string)
	{
		// se tiver espao no nome  considerado invlido
		if (preg_match("/\s/", $string) > 0) return false;
		// se terminar com .alguma_coisa  considerado vlido
		if (preg_match("/\.\w+$/", $string) > 0) return true;
		// se tiver \ ou /  considerado vlido
		if (preg_match("!\\\|/!", $string) > 0) return true;
		return false;
	}
}

?>