<?

class Qi_Html
{
	/**
	* usado internamente para manter o estado do flip
	* null significa sem estados e array a lista de estados possveis
	*/
	private static $flip = null;

	/**
	* Usado principalmente no html, para alterar entre 2 css diferentes:
	* <tr <?=@ Qi_Html::flip("", 'class="cor-fundo"') ?>>... ou:
	* <tr class="<?=@ Qi_Html::flip("par", "impar") ?>">...
	* Chamar flip() sem parametros para reiniciar
	* Opes pode ser um array com as opes
	*/
	public static function flip($opcoes = null)
	{
		if ($opcoes === null) return self::$flip = null;
		if (func_num_args() > 1) $opcoes = func_get_args();
		if (self::$flip === null):
			self::$flip = $opcoes;
			return reset(self::$flip);
		else:
			if ($opcoes !== self::$flip):
				self::flip();
				return self::flip($opcoes);
			endif;
			$return = next(self::$flip);
			return $return === false ? reset(self::$flip) : $return;
		endif;
	}

	public static function impar_par()
	{
		return self::flip("impar", "par");
	}

	public static function par_impar()
	{
		return self::flip("par", "impar");
	}

	/**
	 * Retorna uma string no formato 080129_223033 a data 29/01/2008 22:30:33
	 * para ser usada anexada ao nome de um arquivo para burlar o cache
	 * caso no consiga pegar a data do arquivo, retorna um mt_rand()
	 * @param $timestamp_ou_arquivo int|string timestamp ou o nome do arquivo
	**/
	public static function alterado_em($timestamp_ou_arquivo)
	{
		if (is_numeric($timestamp_ou_arquivo)):
			$alterado_em = $timestamp_ou_arquivo;

		elseif (file_exists($timestamp_ou_arquivo)):
				$alterado_em = filemtime($timestamp_ou_arquivo);

		elseif ($timestamp_ou_arquivo[0] == "/"):
			$raiz = $_SERVER["DOCUMENT_ROOT"];
			$timestamp_ou_arquivo = "$raiz$timestamp_ou_arquivo";
			if (file_exists($timestamp_ou_arquivo))
				$alterado_em = filemtime($timestamp_ou_arquivo);
			else
				$alterado_em = mt_rand(); // caso o arquivo no exista, usar um nmero aleatrio

		else:
			$raiz = dirname($_SERVER["SCRIPT_FILENAME"]);
			$timestamp_ou_arquivo = "$raiz/$timestamp_ou_arquivo";
			if (file_exists($timestamp_ou_arquivo))
				$alterado_em = filemtime($timestamp_ou_arquivo);
			else
				$alterado_em = mt_rand(); // caso o arquivo no exista, usar um nmero aleatrio
		endif;

		return date("ymd_His", $alterado_em);
	}

	/**
	* Retorna a meta-tag <base href="http://localhost/pedidos/empresa/" />
	* para a url: http://localhost/pedidos/empresa/index.php
	* @TODO Qual usar por padro? PHP_SELF ou REQUEST_URI quando mod_rewrite?
	* PHP_SELF estraga formulrios mas arruma imagens relativas
	* REQUEST_URI faz o contrrio
	*/
	public static function base($retornar_apenas_url = false)
	{
		$protocolo = $_SERVER["SERVER_PROTOCOL"]; // exemplo: HTTP/1.1
		list($protocolo) = explode("/", $protocolo);
		$protocolo = strtolower($protocolo);

		$host = strtolower($_SERVER["HTTP_HOST"]); // exemplo: localhost
		//$url = $_SERVER["PHP_SELF"]; // exemplo: /pedidos/empresa/index.php
		$url = $_SERVER["REQUEST_URI"]; // possui o caminho virtual quando usado mod_rewrite
		$path = pathinfo($url); // pedidos/empresa
		$url = $path["dirname"];
		if( $path["basename"] == $path["filename"] ) // /pedidos/empresa/ (empresa == empresa)
			$url .= "/$path[basename]";

		$url_absoluta = "$protocolo://$host$url/"; // precisa da barra no final
		if ($retornar_apenas_url) return $url_absoluta;
		return <<<BASE
	<base href="$url_absoluta" />

BASE;
	}

	/**
		@param $encoding string iso-8859-1 ou UTF-8
	**/
	public static function xml_prolog($encoding = "iso-8859-1")
	{
		return <<<XML
<?xml version="1.0" encoding="$encoding"?>

XML;
	}

	public static function doctype()
	{
		return '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
	"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">'."\n";
	}

	/**
		@param $charset string iso-8859-1 ou UTF-8
	**/
	public static function meta_content_type($charset = "iso-8859-1")
	{
		return <<<ISO
<meta http-equiv="Content-Type" content="text/html; charset=$charset" />

ISO;
	}

	/**
	* Retorna o cdigo necessrio para inserir o google analytics na pgina.
	* J utiliza o cdigo novo lanado no comeo de 2008
	*/
	public static function google_analytics($codigo)
    {
		return <<<GOOGLE

<script type="text/javascript">
var gaJsHost = (("https:" == document.location.protocol) ? "https://ssl." : "http://www.");
document.write(
	unescape(
		"%3Cscript src='" +
		gaJsHost +
		"google-analytics.com/ga.js' type='text/javascript'%3E%3C/script%3E"
	)
);
</script>
<script type="text/javascript">
var pageTracker = _gat._getTracker("$codigo");
pageTracker._initData();
pageTracker._trackPageview();
</script>

GOOGLE;
	}

	/**
		Faz um texto ser seguro para inserir no html
	*/
	public static function h($valor)
	{
		if (get_magic_quotes_gpc()) $valor = stripslashes($valor);
		return htmlspecialchars($valor);
	}

	/**
		retorna ' checked="checked"' caso verdadeiro (repare no espao no comeo!)
		$valor pode ser um boolean direto
		caso $comparacao seja informado, $valor ser comparado com ele
		se $valor no for booleano, compara com strings padres que so consideradas true
	*/
	public static function checked($valor, $comparacao = null)
	{
		return Qi_Util::bool($valor, $comparacao) ? ' checked="checked"' : "";
	}

	/**
		retorna ' selected="selected"' caso verdadeiro (repare no espao no comeo!)
		$valor pode ser um boolean direto
		caso $comparacao seja informado, $valor ser comparado com ele
		se $valor no for booleano, compara com strings padres que so consideradas true
	*/
	public static function selected($valor, $comparacao = null)
	{
		return Qi_Util::bool($valor, $comparacao) ? ' selected="selected"' : "";
	}

	/**
	* @param $arquivo string Coloca embrulha o arquivo atual, com o layout informado
	* no layout, deve existir uma varivel chamada $TPL, que conter o arquivo atual.
	* Esta funo deve ser chamada antes de executar o template
	*/
	public static function layout($layout, $vars = array())
	{
		register_shutdown_function(
			array("Qi_Html", "_layout_shutdown_function"), 
			realpath($layout),
			$vars
		);
		ob_start();
	}

	public static function _layout_shutdown_function($layout, $vars = array())
	{
		$TPL = ob_get_clean();
		extract($vars);
		include $layout;
	}
}

?>