<?

class Qi_Http_Mime
{
	/**
	* cache interno do arquivo mime_types.ini
	*/
	private static $todas = array();

	/**
	* Quando a extenso no  encontrada, este ser o valor padro retornado.
	*/
	const PADRAO = "application/octet-stream";

	/**
	* @param string Dado um nome de arquivo ao apenas a extenso, retorna o respectivo MimeType
	* @param string informar o mimetype padro que dever ser retornado caso no encontrar.
	*/
	public static function ext($string, $padrao = self::PADRAO)
	{
		$ext = pathinfo($string, PATHINFO_EXTENSION);
		if ($ext == "") $ext = $string;
		$ext = strtolower($ext);
		$todas = self::todas();
		$mime = isset($todas[$ext]) ? $todas[$ext] : $padrao;
		return strtolower($mime);
	}

	/**
	* Carrega todos MimeTypes do arquivo mime_types.ini na mesma pasta desta classe
	* Carrega apenas quando fizer a primeira chamada, fazendo cache para as seguintes
	*/
	public static function todas()
	{
		if (!empty(self::$todas)) return self::$todas;
		$ini = dirname(__FILE__)."/mime_types.ini";
		self::$todas = parse_ini_file($ini);
		ksort(self::$todas);
		return self::$todas;
	}
}

?>