<?

class Qi_Permissao
{
	/**
	* Objeto que faz a verificao de permisso, normalmente uma instncia de
	* Qi_Permissao
	*/
	private static $verificador = null;

	/**
	* Array mapeado de permisses. recurso => permitido
	*/
	private $permissoes = array();

	/**
	* Configuraes para utilizar em uma tabela legada.
	*/
	public $conf = array (
		// nome da tabela de permisses no banco
		"tabela" => "qi_permissoes",
		// nome do campo que contm o nome do usurio
		"usuario" => "usuario",
		// nome do campo que armazena o recurso
		"recurso" => "recurso",
		// nome do campo que guarda a permisso 0 ou 1
		"tem_permissao" => "tem_acesso"
	);

	public function __construct($usuario = null)
	{
		if ($usuario == null) return;
		if (is_array($usuario)) 
			return $this->permissoes = $usuario;

		$_ = Qi_Db_Sql::formatar_por_tipo($usuario);
		extract($this->conf);
		$permissoes = Qi_Db::query(
			"SELECT LOWER($recurso) as recurso, $tem_permissao
			FROM $tabela
			WHERE $usuario = $_"
		);
		$this->permissoes = iterator_to_array(new Qi_It_ChaveValor($permissoes));
	}

	/**
	* Mtodo que verifica permisso do recurso no array interno.
	* @TODO implementar suporte para o wildcard "*"
	*/
	public function verificar($recurso)
	{
		$recurso = strtolower(trim($recurso));
		if ( isset($this->permissoes[$recurso]) )
			return Qi_Util::bool($this->permissoes[$recurso]);
		elseif( isset($this->permissoes["*"]) )
			return Qi_Util::bool($this->permissoes["*"]);
		return false;
	}

	/**
	* inicializa as permisses do usurio informado.
	*/
	public static function criar($usuario = null)
	{
		self::$verificador = new Qi_Permissao($usuario);
	}

	/**
	* apenas um atalho para no precisar fazer:
	* if ( ! Qi_Permissao::tem_acesso() )
	*/
	public static function nao_tem_acesso($recurso)
	{
		return ! self::tem_acesso($recurso);
	}

	/**
	* Pergunta para classe se o usurio tem acesso ao recurso informado
	*/
	public static function tem_acesso($recurso)
	{
		return self::$verificador->verificar($recurso);
	}
}

/*
CREATE TABLE `qi_permissoes` (
  `usuario` varchar(255) NOT NULL,
  `recurso` varchar(255) NOT NULL,
  `tem_acesso` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`recurso`,`usuario`)
);
*/

?>