<?

/**
* Esta classe  o Writer, criar um Reader
* Criar mtodo ou classe para gerar um arquivo php auto suficiente,
* 	para ser usado como ponto de entrada na web.
* Uma opo  criar um .htaccess que redireciona tudo para ele,
*	caso o resource no esteja dentro dele, 
*	ele envia um header Location com alguma informao que faa passar atravs do ModRewrite
*	ou ele mesmo carrega o resource e envia para o cliente.
*/
class Qi_Tools_Resource
{
	/**
	* Onde ser salvo o arquivo de resource.
	*/
	private $stream_dest = null;

	/**
	* Controla quantos bytes j foram adicionados
	*/
	private $offset = 0;

	/**
	* Array de metadados sobre os resources
	*/
	public $meta = array();

	/**
	* @param $stream_dest Stream ou string contendo o nome do arquivo,
	* onde ser salvo o arquivo de resources
	*/
	public function __construct($stream_dest)
	{
		if (is_string($stream_dest))
			$stream_dest = fopen($stream_dest, "wb");
		$this->stream_dest = $stream_dest;
	}

	/**
	* Salva um arquivo no $stream_dest e adiciona os respectivos metadados no array $meta
	*/
	public function add($arquivo)
	{
		$fp = fopen($arquivo, "rb");
		stream_copy_to_stream($fp, $this->stream_dest);
		$stat = fstat($fp);
		fclose($fp);

		$metadados["name"] = basename($arquivo);
		$metadados["path"] = $arquivo; // precisa converter \ em / e ter um caminho relativo ao DOCUMENT_ROOT
		$metadados["mime"] = Qi_Http_Mime::get($arquivo);
		$metadados["offset"] = $this->offset;
		$metadados["length"] = $stat["size"];

		$this->meta[$metadados["path"]] = $metadados;
		$this->offset += $metadados["length"];
		return $metadados;
	}
}

?>