<?

/**
* Funes que no se adequam em um pacote especfico,
* com aplicaes diversificadas.
* Todas as funes orfans comeam aqui, assim que um grupo surgir,
* elas sero separadas em uma outra classe.
*/
class Qi_Util
{
	/**
	* Strings que so consideradas true. Todo o resto  considerado false
	*/
	public static $VALORES_VERDADEIROS = array("S", "SIM",
											   "Y", "YES",
											   "1", "ON", "OK",
											   "T", "TRUE",
											   "V", "VERDADEIRO", "VERDADE",
											   "ATIVO", "LIGADO", "ABERTO", "ENVIADO");
	/**
	* verifica se o valor  booleano ou se  igual  $comparacao
	* valores considerados true so as strings no array self::$VALORES_VERDADEIROS
	*/
	public static function bool($valor, $comparacao = null)
	{
		if ($comparacao !== null) return $valor == $comparacao;
		if (!is_bool($valor))
			$valor = in_array( strtoupper($valor), self::$VALORES_VERDADEIROS );
		return $valor;
	}

	/**
	* Converte "Publicao da  rvore - 2" em "publicacao_da_arvore-2"
	* podendo ser usado como nome de classe, id, menos varivel de programao
	* @TODO se precisar, adicionar um parmetro no final para converter - em _
	*/
	public static function id($palavra)
	{
		$palavra = strtolower($palavra);
		$palavra = preg_replace("/\W+/", "_", $palavra);
		return $palavra;
	}

	/**
	 * Converte uma string com lista de valores ou um iterator em array
	 * @assert "nome, endereco | telefone" = array("nome", "endereco", "telefone")
	 * @assert "adm/boletos/12/enviar" = array("adm", "boletos", "12", "enviar")
	**/
	public static function to_a($lista)
	{
		if ( is_string($lista) ) return split("[,;|.:/\ ]+", $lista);
		if ( is_array($lista) ) return $lista;
		if ( $lista instanceof Iterable ) return iterator_to_array($lista);
		if ( is_object($lista) ) return iterator_to_array(new ArrayObject($lista));
		return func_get_args();
	}

	/**
	* Converte o valor float para moeda real: 
	* 10.014 = "10,01"
	* 10.015 = "10,02"
	* Tambm aceita valor em string, tanto em formato real como dolar:
	* "1.000,05" = "1.000,05"
	* "1000,05"  = "1.000,05"
	* "1,000.05" = "1.000,05"
	* @return string valor monetrio formatado assim: 
	*/
	public static function real($float)
	{
		// se no for numrico, converte a string para float
		if (!is_numeric($float)) $float = self::float($float);
		return number_format($float, 2, ",", ".");
	}

	/**
	* Faz exatamente o mesmo que a funo acima, 
	* mas retorna o valor formatado em dolar
	*/
	public static function dolar($float)
	{
		if (!is_numeric($float)) $float = self::float($float);
		return number_format($float, 2, ".", ",");
	}

	/**
		Transforma algo como, data_nascimento em Data Nascimento
	*/
	public static function rotulo($palavra)
	{
		$palavra = preg_replace("/[-_\W]+/", " ", $palavra);
		$palavra = trim($palavra);
		$palavra = ucwords($palavra);
		return $palavra;
	}

	/**
	* @return float da string ou um numero
	* Nao coloca separador de milhar, 
	* pois o valor  um float e no uma string representando dlar.
	*/
	public static function float($str)
	{
		$str = trim($str);
		if (strlen($str) == 0) return 0;
		if (is_numeric($str)) return floatval($str);
		$negativo = $str[0] == "-" ? "-" : "";
		$lista = preg_split("/[^\d]/", $str); // separa todos os dgitos usando os no dgitos
		$decimal = array_pop($lista); // pega o ultimo
		$dolar = join("", $lista); // junta todos menos o ultimo (sem sinal ou separador, apenas numeros)
		$dolar = "$negativo$dolar.$decimal"; // colocar o decimal no fim
		return floatval($dolar);
	}

	/**
	 * Utiliza a funo fopen com use_include_path = true, para verificar se o arquivo existe.
	 * @TODO verificar se  possvel fazer o mesmo com stream_resolve_include_path
	**/
	public static function consigo_incluir($arquivo)
	{
		$ponteiro = @fopen($arquivo, "r", true);
		if ($ponteiro === false) return false;
		fclose($ponteiro);
		return true;
	}

	/**
	* @return bool true se o sistema operacional for windows
	*/
	public static function eh_windows()
	{
		return strtoupper(substr(PHP_OS, 0, 3)) == 'WIN';
	}

	/**
	* @return bool true se o script estiver rodando na web,
	* false se estiver rodando na linha de comando
	*/
	public static function eh_web()
	{
		return PHP_SAPI == "apache";
	}

	/**
	* Sem parmetros, retorna o nome do primeiro arquivo executado pelo PHP
	* Se informar um caminho no parmetro, normalmente __FILE__, 
	* retorna um booleano dizendo se os dois caminhos so iguais.
	* @TODO verificar se realmente continuar usando realpath(), 
	* 		pois ele parece acessar o disco e verificar a existncia real do arquivo
	* 		retorna false caso no consiga.
	*/
	public static function script_boot($__FILE__ = null)
	{
		$included_files = get_included_files();
		$boot = realpath($included_files[0]);
		return $__FILE__ === null ? $boot : realpath($__FILE__) === $boot;
	}

	/**
	* Executa um comando shell e retorna a saida. 
	* @TODO Tentar com vrias funes at encontrar uma que no esteja bloqueada.
	*/
	public static function exec($cmd)
	{
		return `$cmd`;
	}
}

?>