<?

class Qi_Util_Tokenizer
{
	/**
	* Retorna apenas um array mapeado com as constantes (e seus valores) definidas internamente pelo php
	* @param $ordenar_por_valor O normal  ordenar pelas chaves que so os nomes das constantes.
	*/
	public static function constantes($ordenar_por_valor = false)
	{
		$array = Qi_Tools_PhpInfo_Extensions::listar("constants", "tokenizer");
		if ($ordenar_por_valor) asort($array);
		return $array;
	}

	/**
	* Apenas carrega o conteudo do arquivo para uma string, para passar na funo abaixo
	*/
	public static function arquivo($arquivo)
	{
		$source = file_get_contents($arquivo);
		return self::string($source);
	}

	/**
	 * Retorna o array de tokens do codigo na string do parmetro, normalizado, ou seja: 
	 * array("codigo" => 307, "conteudo" => "<?=@", "linha" => 18, "const" => "T_OPEN_TAG_WITH_ECHO")
	 * Todos os ndices so arrays, ao invs do padro que  ter ndices array e outros como texto apenas
	 * Devido a converso acima, a linha indicada pode no ser a correta, pois ele utiliza a ltima linha como referncia.
	 * O quarto ndice do array possui o nome do token correspondente, UNKNOWN quando sofrer a converso acima.
	 * Fora esta normalizao, nenhuma alterao  feita no array.
	**/
	public static function string($source)
	{
		$tokens = token_get_all($source);
		$last_line = 1;
		$new_tokens = array();
		foreach($tokens as $i=>$token):
			if (!is_array($token)) 
				$new = array("codigo" => 0, "conteudo" => $token, "linha" => $last_line);
			else 
				$new = array("codigo" => $token[0], "conteudo" => $token[1], "linha" => $token[2]);

			$new["const"] = token_name($new["codigo"]);
			$last_line = $new["linha"];
			$new_tokens[] = $new;
		endforeach;
		return $new_tokens;
	}

	/**
	 * Retorna o cdigo fonte php codificado pelo array de tokens.
	 * Sempre o cdigo retornado por esta funo, 
	 * deve ser exatamente igual ao cdigo fonte que gerou este array de tokens.
	**/
	public static function php($tokens)
	{
		$tokens = self::to_a($tokens);
		$php = "";
		foreach($tokens as $token) $php .= $token["conteudo"];
		return $php;
	}

	/**
	*  comum aplicar os mtodos desta classe em uma string, um arquivo ou um array de tokens
	* Este mtodo converte todos os casos acima para um array de tokens
	*/
	private static function to_a($tokens)
	{
		if (is_string($tokens))
			if (Qi_File::string_eh_arquivo($tokens))
				return self::arquivo($tokens);
			else
				return self::string($tokens);

		return $tokens;
	}

	/**
	 * Retorna o cdigo fonte php em html, mas com tags <span class="nome_constante"></span>
	 * em volta de cada elemento.
	**/
	public static function html($tokens)
	{
		$tokens = self::to_a($tokens);

		$html = "";
		foreach($tokens as $token):
			$conteudo = htmlspecialchars($token["conteudo"]);
			$html .= "<span class=\"$token[const]\">$conteudo</span>";
		endforeach;
		return $html;
	}

	/**
	 * Dado um array de tokens, retorna uma string binria.
	 * Se o arquivo for informado, os dados tambpem sero escritos nele.
	**/
	public static function tokens2bin($tokens, $arquivo = null)
	{
		$tokens = self::to_a($tokens);
		$binario = "";
		foreach($tokens as $token):
			extract($token);
			// faz o menor valor de token (T_REQUIRE_ONCE => 258), ser o indice 1,
			// assim todos os 119 tokens cabem em 7 bits de informao,
			// sobrando 128 combinaes diferentes para tokens customizados.
			$codigo = max($token["codigo"] - 257, 0);
			$tamanho = strlen($conteudo);
			$pack = pack("nCn", $linha, $codigo, $tamanho);
			$binario .= $pack.$conteudo;
		endforeach;
		if ($arquivo !== null) file_put_contents($arquivo, $binario);
		return $binario;
	}

	/**
	 * Faz o reverso da funo acima,
	 * dado uma string binria, retorna o array de tokens
	**/
	public static function bin2tokens($string)
	{
		$tokens = array();
		$len = strlen($string);
		$i = 0;
		while($i < $len):
			$cinco = substr($string, $i, 5);
			$i += 5;
			$array = unpack("na/Cb/nc", $cinco);
			$array = array_values($array);
			list($linha, $codigo, $tamanho) = $array;
			$conteudo = substr($string, $i, $tamanho);
			$i += $tamanho;
			$codigo += 257;
			if ($codigo == 257) $codigo = 0;
			$const = token_name($codigo);
			$tokens[] = compact("codigo", "conteudo", "linha", "const");
		endwhile;

		return $tokens;
	}
}

?>