<?

Qi_Util_Tokenizer_Novos::criar_constantes_novas();

/**
* Cria novas constantes para smbolos no mapeados pelo tokenizer interno do PHP
*/
class Qi_Util_Tokenizer_Novos
{
	static $traducao = array (
		"=" => 'T_ASSIGN'
		,'"' => 'T_DOUBLE_QUOTED_STRING'
		,":" => 'T_COLON'
		,";" => 'T_SEMICOLON'
		,"," => 'T_COMMA'
		,"." => 'T_CONCAT'
		,"(" => 'T_OPEN_PARENTHESIS'
		,")" => 'T_CLOSE_PARENTHESIS'
		,"[" => 'T_OPEN_SQUARE_BRACKET'
		,"]" => 'T_CLOSE_SQUARE_BRACKET'
		,"{" => 'T_OPEN_CURLY_BRACKET'
		,"}" => 'T_CLOSE_CURLY_BRACKET'
		,"+" => 'T_PLUS'
		,"-" => 'T_MINUS'
		,"*" => 'T_MULTIPLY'
		,"/" => 'T_DIVIDE'
		,"%" => 'T_MODULUS'
		,"!" => 'T_BOOLEAN_NOT'
		,"<" => 'T_IS_LESS_THAN'
		,">" => 'T_IS_GREATER_THAN'
		,"&" => 'T_BITWISE_AND'
		,"|" => 'T_BITWISE_OR'
		,"^" => 'T_BITWISE_XOR'
		,"null" => 'T_NULL'
		,"false" => 'T_FALSE'
		,"true" => 'T_TRUE'
		,"self" => 'T_SELF'
		,"parent" => 'T_PARENT'
		,"@" => 'T_ERROR_CONTROL'
	);

	/**
	* As constantes novas, comeam com cdigo apartir do 128
	* @TODO atualizar token2bin para suportar estes novos tokens
	*/
	public static function criar_constantes_novas()
	{
		$code = 128;
		foreach(self::$traducao as $v):
			if (defined($v)) continue;
			define($v, $code);
			$code++;
		endforeach;
	}

	/**
	* Recebe um array de tokens j formatado e traduz os novos tokens
	*/
	public static function traduzir(array $tokens)
	{
		$novos = array();
		foreach($tokens as $token):
			$conteudo = strtolower($token["conteudo"]);
			//$token["novo"] = false;
			if ( isset(self::$traducao[$conteudo]) ):
				$const = self::$traducao[$conteudo];
				$token["codigo"] = constant($const);
				$token["const"] = $const;
				//$token["novo"] = true;
			endif;
			$novos[] = $token;
		endforeach;
		return $novos;
	}

	public static function eh_novo($token)
	{
		return in_array($token, self::$traducao);
	}
}

/* tens que ainda faltam mas precisa de tratamento mais elaborado:
T_STRING
	T_FUNCTION_NAME Nome de declarao da funo
	T_CLASS_NAME Nome de declarao d classe 
	T_INTERFACE_NAME nome de declarao interface
	propriedade de um objeto: $obj->v
	T_TICKS = declare(ticks=1)
	T_PARAMETER = T_VARIABLE em declarao de funo ou mtodo
	T_PROPERTY = T_VARIABLE em declarao de varivel de classe
*/
?>