<?php
	require 'framework/configs.php';
	require 'wp/wp-load.php';

	$args = array(
		'posts_per_page' => 2
	);

	$wp_query = new WP_Query( $args );

	$postsAr = array();
	
	while ($wp_query->have_posts()) {
		$wp_query->the_post();

		$post = array();
		$post['id'] = $wp_query->post->ID;
		$post['slug'] = $wp_query->post->post_name;
		$post['title'] = $wp_query->post->post_title;
		$post['content'] = $wp_query->post->post_content;
		$post['date'] = $wp_query->post->post_date;
		$post['thumb'] = wp_get_attachment_image_src ( get_post_thumbnail_id( $wp_query->post->ID ), 'medium' );

		$postsAr[] = $post;
	}

	if (count($postsAr) > 0) {
		$smarty->assign('posts', $postsAr);
	}
	
	$smarty->display('index.tpl');