<!DOCTYPE html>
<html lang="pt-br">

<head>
    <base href="/">

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <title>{#title#}</title>

    <link rel="shortcut icon" href="./css/img/favicon.png" />
    <link rel="stylesheet" href="//maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css">
    <link rel="stylesheet" href="//cdn.jsdelivr.net/gh/kenwheeler/slick@1.8.1/slick/slick.css" />
    <link rel="stylesheet" href="//cdn.jsdelivr.net/gh/kenwheeler/slick@1.8.1/slick/slick-theme.css" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/gh/fancyapps/fancybox@3.5.7/dist/jquery.fancybox.min.css" />
    <link rel="stylesheet" href="css/style.css?v={$smarty.now}">
    {literal}
        <!-- Global site tag (gtag.js) - Google Analytics -->
        <script async src="https://www.googletagmanager.com/gtag/js?id=G-F538XE6D54"></script>
        <script>
          window.dataLayer = window.dataLayer || [];
          function gtag(){dataLayer.push(arguments);}
          gtag('js', new Date());
        
          gtag('config', 'G-F538XE6D54');
        </script>
        
        <!-- Global site tag (gtag.js) - Google Analytics -->
        <script async src="https://www.googletagmanager.com/gtag/js?id=UA-196467595-1"></script>
        <script>
          window.dataLayer = window.dataLayer || [];
          function gtag(){dataLayer.push(arguments);}
          gtag('js', new Date());
        
          gtag('config', 'UA-196467595-1');
        </script>
        
        <!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=UA-232208554-1">
</script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'UA-232208554-1');
</script>

    {/literal}
</head>

<body class="d-flex flex-column {$lang}">
    {include file="includes/apresentacao.tpl"}

    <header class="container-fluid header">
        <div class="row">
            <div class="col-12 wrap-fone">
                <div class="container">

                    <div class="vendas">
                        <span>{L::vendas}: (47) 3255-8383 | <a href="javascript:;" data-toggle="modal" data-target="#modalApresentacao">{L::soliciteApresentacao}</a></span>
                    </div>

                    <div class="social">
                        <a href="https://www.facebook.com/okeatecnologia" target="_blank">
                            <div class="facebook hover-effect">
                                <img src="./css/img/facebook.png" />
                            </div>
                        </a>
                        <a href="https://www.instagram.com/okeatecnologia/" target="_blank">
                            <div class="instagram hover-effect">
                            <img src="./css/img/instagram.png" />
                            </div>
                        </a>
                    </div>

                </div>
            </div>
            <div class="col-12 wrap-menu">
                <div class="container d-none d-sm-none d-md-block">
                    <div class="row">
                        <div class="col-9 d-flex align-items-center">
                            <a href="./">
                                <div class="sprite logo hover-effect">
                                    <span></span>
                                </div>
                            </a>
                            <ul class="menu">
                                <li>
                                    <a href="./">{L::menu_home}</a>
                                </li>
                                <li>
                                    <a href="./solucoes">
                                        {L::menu_solucoes}
                                    </a>
                                    <ul>
                                        <li><a href="./solucoes/chemic">Chemic</a></li>
                                        <li><a href="./solucoes/food">Food</a></li>
                                        <li><a href="./solucoes/loom">Loom</a></li>
                                        <li><a href="./solucoes/papers">Papers</a></li>
                                        <li><a href="./solucoes/polymer">Polymer</a></li>
                                    </ul>
                                </li>
                                <li>
                                    <a href="./institucional">{L::menu_institucional}</a>
                                </li>
                                <li>
                                    <a href="./contato">{L::menu_contato}</a>
                                </li>
                                <li>
                                    <a href="./blog">{L::menu_blog}</a>
                                </li>
                            </ul>
                        </div>
                        <div class="col-3 d-flex align-items-center justify-content-end">
                            <div class="wrap-langs d-flex">
                                <a href="./lang/?lang=pt">
                                    <div class="sprite-flags portugues hover-effect">
                                        <span></span>
                                    </div>
                                </a>
                                <a href="./lang/?lang=en">
                                    <div class="sprite-flags ingles hover-effect">
                                        <span></span>
                                    </div>
                                </a>
                                <a href="./lang/?lang=es">
                                    <div class="sprite-flags espanhol hover-effect">
                                        <span></span>
                                    </div>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="container d-block d-sm-block d-md-none">
                    <nav class="navbar">
                        <a class="navbar-brand" href="./">
                            <div class="sprite logo hover-effect">
                                <span></span>
                            </div>
                        </a>
                        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#menu" aria-controls="menu" aria-expanded="false"
                            aria-label="Toggle navigation">
                            <span class="navbar-toggler-icon"></span>
                        </button>
                        <div class="collapse navbar-collapse justify-content-start" id="menu">
                            <ul class="navbar-nav">
                                <li class="nav-item">
                                    <a class="nav-link" href="./">{L::menu_home}</a>
                                </li>
                                <li class="nav-item dropdown">
                                    <a class="nav-link dropdown-toggle" href="./solucoes" id="navbarDropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        {L::menu_solucoes}
                                    </a>
                                    <div class="dropdown-menu" aria-labelledby="navbarDropdownMenuLink">
                                        <a href="./solucoes/chemic" class="dropdown-item">Chemic</a>
                                        <a href="./solucoes/food" class="dropdown-item">Food</a>
                                        <a href="./solucoes/loom" class="dropdown-item">Loom</a>
                                        <a href="./solucoes/papers" class="dropdown-item">Papers</a>
                                        <a href="./solucoes/polymer" class="dropdown-item">Polymer</a>
                                    </div>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href="./institucional">{L::menu_institucional}</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href="./contato">{L::menu_contato}</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href="./blog">{L::menu_blog}</a>
                                </li>
                            </ul>
                        </div>
                    </nav>
                </div>
            </div>
        </div>
    </header>

    <main role="main" class="container-fluid main">
