

var spinner = function () {
    setTimeout(function () {
        if ($("#spinner").length > 0) {
            $("#spinner").removeClass("show");
        }
    }, 1);
};
spinner();


document.addEventListener('DOMContentLoaded', function() {
    const navbarToggler = document.querySelector('.navbar-toggler');
    const navbarCollapse = document.getElementById('navbarCollapse');

    function closeNavbar() {
        if (getComputedStyle(navbarToggler).display !== 'none' && navbarToggler.getAttribute('aria-expanded') === 'true') {
            navbarToggler.click();
        }
    }

    window.addEventListener('resize', closeNavbar);

    document.addEventListener('click', function(event) {
        if (!navbarCollapse.contains(event.target) && !navbarToggler.contains(event.target)) {
            closeNavbar();
        }
    });

    document.querySelectorAll('#navbarCollapse .nav-link').forEach(function(item) {
        item.addEventListener('click', function() {
            closeNavbar();
        });
    });
});

gsap.registerPlugin(ScrollTrigger);

let image = document.querySelector(".tela");
if (image) {
    gsap.set(image, {
        scale: 0.5,
        y: "30%",
    });

    gsap.to(image, {
        scrollTrigger: {
            trigger: ".trigger-1",
            start: "center center",
            scrub: true,
            toggleActions: "restart pause reverse pause",
        },
        scale: 1,
        y: "0%",
        ease: "power1.out",
    });
}



let items = document.querySelectorAll('.carousel .carousel-item')

items.forEach((el) => {
    const minPerSlide = 2
    let next = el.nextElementSibling
    for (var i=1; i<minPerSlide; i++) {
        if (!next) {
        	next = items[0]
      	}
        let cloneChild = next.cloneNode(true)
        el.appendChild(cloneChild.children[0])
        next = next.nextElementSibling
    }
})

$(document).ready(function () {
    $('#testimonials').owlCarousel({
        loop: true,
        autoplay: false,
        slideSpeed: 600,
        margin: 20,
        mouseDrag: true,
        responsive: {
            0: {
                items: 1
            },
            600: {
                items: 1
            },
            1000: {
                items: 2
            }
        }
    });

    var owl = $(".owl-carousel");
	owl.owlCarousel();
	$(".next-btn").click(function () {
		owl.trigger("next.owl.carousel");
	});
	$(".prev-btn").click(function () {
		owl.trigger("prev.owl.carousel");
	});

});


$(document).ready(function() {
    $('#contatoForm').submit(function(e) {
        e.preventDefault();
        var form = $(this);
        var submitBtn = form.find('.submit_btn');
        var statusMsg = form.find('.status-msg');

        statusMsg.text('Enviando Mensagem...').removeClass('d-none').removeClass('text-danger').removeClass('text-success');

        $.ajax({
            type: 'POST',
            url: form.attr('action'),
            data: form.serialize(),
            dataType: 'json',
            beforeSend: function() {
                submitBtn.html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> ENVIANDO');
            },
            success: function(response) {
                statusMsg.addClass('d-none').text('');

                if (response.status === 'error') {
                    statusMsg.text(response.message).removeClass('d-none').addClass('text-danger');
                } else if (response.status === 'success') {
                    statusMsg.text(response.message).removeClass('d-none').addClass('text-successo');
                    form.trigger('reset');
                }
            },
            error: function(xhr) {
                console.error(xhr);
                statusMsg.text(xhr.responseJSON.message).removeClass('d-none').addClass('text-danger');
            },
            complete: function() {
                submitBtn.html('ENVIAR');
            }
        });
    });
});

jQuery("input.telefone")
    .mask("(99) 9999-9999?9")
    .focusout(function (event) {
        var target, phone, element;
        target = event.currentTarget ? event.currentTarget : event.srcElement;
        phone = target.value.replace(/\D/g, "");
        element = $(target);
        element.unmask();
        if (phone.length > 10) {
            element.mask("(99) 99999-999?9");
        } else {
            element.mask("(99) 9999-9999?9");
        }
    });


    (function ($) {
        const hideScrollArrows = () => {
            const distanceFromBottom = $(document).height() - $(window).height() - $(window).scrollTop();
            if (distanceFromBottom <300) {
                $('.scrollHome').addClass('d-none');
            } else {
                $('.scrollHome').removeClass('d-none');
            }
        };

        $(window).scroll(hideScrollArrows);
        $(document).ready(hideScrollArrows);
    })(jQuery);




    let cursor = 0;
    const KONAMI_CODE = [38, 38, 40, 40, 37, 39, 37, 39, 66, 65];
    document.addEventListener("keydown", (e) => {
        cursor = e.keyCode == KONAMI_CODE[cursor] ? cursor + 1 : 0;
        if (cursor == KONAMI_CODE.length) activate();
    });

    var activate = () => {
        Swal.fire({
            confirmButtonColor: "#791f80",
            imageUrl: "https://desenvolto.com.br/anderson.png",
            imageHeight: 300,
            imageAlt: "Anderson"
          });
    };
