<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
                Categorias
            </h2>
            <button type="submit" onclick="openModal('formModal')"
                class="flex items-center gap-2 text-white bg-green-600 hover:bg-green-700 focus:ring-4 focus:outline-none focus:ring-green-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center w-fit">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd"
                        d="M2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12ZM12 4C7.58172 4 4 7.58172 4 12C4 16.4183 7.58172 20 12 20C16.4183 20 20 16.4183 20 12C20 7.58172 16.4183 4 12 4Z"
                        fill="currentColor" />
                    <path fill-rule="evenodd" clip-rule="evenodd"
                        d="M13 7C13 6.44772 12.5523 6 12 6C11.4477 6 11 6.44772 11 7V11H7C6.44772 11 6 11.4477 6 12C6 12.5523 6.44772 13 7 13H11V17C11 17.5523 11.4477 18 12 18C12.5523 18 13 17.5523 13 17V13H17C17.5523 13 18 12.5523 18 12C18 11.4477 17.5523 11 17 11H13V7Z"
                        fill="currentColor" /></svg>
                Nova Categoria
            </button>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-2xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900 dark:text-gray-100">
                    <h1 class="text-sm text-red-600 font-bold text-center italic p-2">** ATENÇÂO! Ao excluir uma
                        categoria, todos os posts relacionados a ela também serão excluídos.</h1>

                    <div class="overflow-x-scroll">
                        <table class="w-full mx-auto divide-y divide-gray-200 mt-6">
                            <thead>
                                <tr>
                                    <th
                                        class="text-left px-6 py-3 text-xs font-medium text-gray-500 uppercase tracking-wider">
                                        Nome</th>
                                    <th
                                        class="text-center px-6 py-3 text-xs font-medium text-gray-500 uppercase tracking-wider">
                                        Última Atualização</th>
                                    <th
                                        class="text-center px-6 py-3 text-xs font-medium text-gray-500 uppercase tracking-wider">
                                        Ações</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">

                                @foreach ($categories as $category)
                                <tr>
                                    <td class="px-6 py-4 whitespace-nowrap text-left">{{ $category->name }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-xs text-center">
                                        {{ $category->last_update }}
                                    </td>

                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <button onclick="openEditModal({{ json_encode($category) }})"
                                            class="px-3 py-1 font-medium text-white bg-cyan-700 rounded-md hover:bg-cyan-800 focus:outline-none focus:shadow-outline-blue active:bg-cyan-700 transition duration-150 ease-in-out">Edit</button>

                                        <!-- Botão de Excluir -->
                                        <button onclick="openDeleteModal({{ json_encode($category) }})"
                                            class="ml-2 px-3 py-1 font-medium text-white bg-pink-700 rounded-md hover:bg-pink-800 focus:outline-none focus:shadow-outline-red active:bg-pink-700 transition duration-150 ease-in-out">
                                            Delete
                                        </button>

                                        <!-- Formulário Oculto para Exclusão -->
                                        <form id="deleteForm" method="POST"
                                            action="{{ route('dashboard.categories.destroy', $category->id) }}"
                                            style="display: none;">
                                            @csrf
                                            @method('DELETE')
                                            <!-- Campo oculto para confirmar a exclusão -->
                                            <input type="hidden" name="category_id" id="deleteCategoryId">
                                        </form>

                                    </td>
                                </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>

                    <div class="mt-4 p-4">
                        {{ $categories->links() }}
                    </div>


                </div>
            </div>
        </div>
    </div>

    @if (session('success'))
    <div id="toastSuccess" class="fixed inset-x-0 top-0 flex items-end justify-right px-4 py-6 justify-end">
        <div
            class="max-w-sm w-full shadow-lg rounded px-4 py-3 relative bg-green-400 border-l-4 border-green-700 text-white">
            <div class="p-2">
                <div class="flex items-start">
                    <div class="ml-3 w-0 flex-1 pt-0.5">
                        <p class="text-sm leading-5 font-medium">
                            {{ session('success') }}
                        </p>
                    </div>
                    <div class="ml-4 flex-shrink-0 flex">
                        <button class="inline-flex text-white transition ease-in-out duration-150"
                            onclick="return this.parentNode.parentNode.parentNode.parentNode.remove()">
                            <svg class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd"
                                    d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                                    clip-rule="evenodd" />
                            </svg>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @elseif (session('error'))
    <div id="toastError" class="fixed inset-x-0 top-0 flex items-end justify-right px-4 py-6 justify-end">
        <div
            class="max-w-sm w-full shadow-lg rounded px-4 py-3 relative bg-yellow-400 border-l-4 border-yellow-700 text-white">
            <div class="p-2">
                <div class="flex items-start">
                    <div class="ml-3 w-0 flex-1 pt-0.5">
                        <p class="text-sm leading-5 font-medium">
                            {{ session('error') }}
                        </p>
                    </div>
                    <div class="ml-4 flex-shrink-0 flex">
                        <button class="inline-flex text-white transition ease-in-out duration-150"
                            onclick="return this.parentNode.parentNode.parentNode.parentNode.remove()">
                            <svg class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd"
                                    d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                                    clip-rule="evenodd" />
                            </svg>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif


    <div id="formModal" class="fixed hidden z-50 inset-0 bg-gray-900 bg-opacity-60 overflow-y-auto h-full w-full px-4">
        <div class="relative top-40 mx-auto shadow-xl rounded-md bg-white max-w-md">
            <div class="flex justify-end p-2">
                <button onclick="closeModal('formModal')" type="button"
                    class="closeModalBtn disabled:opacity-70 disabled:cursor-not-allowed text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd"
                            d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                            clip-rule="evenodd"></path>
                    </svg>
                </button>
            </div>

            <div class="spinner pt-6 pb-10 text-center flex-spinner justify-center hidden">
                <svg class=" animate-spin h-20 w-20 text-brand-blue" width="24" height="24" viewBox="0 0 24 24"
                    fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path opacity="0.2" fill-rule="evenodd" clip-rule="evenodd"
                        d="M12 19C15.866 19 19 15.866 19 12C19 8.13401 15.866 5 12 5C8.13401 5 5 8.13401 5 12C5 15.866 8.13401 19 12 19ZM12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22Z"
                        fill="currentColor" />
                    <path d="M2 12C2 6.47715 6.47715 2 12 2V5C8.13401 5 5 8.13401 5 12H2Z" fill="currentColor" />
                </svg>
            </div>

            <div class="content p-6 pt-0 text-center">
                <form method="POST" action="{{ route('categories.store') }}" id="categoryForm" class="max-w-sm mx-auto">
                    @csrf
                    <input type="hidden" name="_method" id="formMethod" value="POST">
                    <input type="hidden" name="category_id" id="categoryId" value="">

                    <div class="mb-5">
                        <label for="categoria" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Nome
                            da Categoria</label>
                        <input type="text" id="categoria" name="name" required
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-brand-blue focus:border-brand-blue block w-full p-2.5"
                            placeholder="Nome da categoria" required />
                    </div>

                    <div class="flex justify-end gap-2">
                        <button href="#" onclick="closeModal('formModal')" id="cancelBtn2"
                            class="text-gray-700 bg-white hover:bg-gray-100 focus:ring-4 focus:ring-cyan-200 border border-gray-200 font-medium rounded-lg text-sm w-32 text-center px-5 py-2.5"
                            data-modal-toggle="delete-user-modal">
                            Cancelar
                        </button>

                        <button type="submit" id="submitBtn"
                            class="text-white bg-brand-blue hover:bg-brand-blue-2 focus:ring-4 focus:outline-none focus:ring-brand-blue font-medium rounded-lg text-sm w-32 text-center px-5 py-2.5">
                            <div class="mx-auto flex itens-center justify-center gap-2">
                                Salvar
                            </div>
                        </button>
                    </div>
                </form>

            </div>
        </div>
    </div>

    <div id="deleteModal"
        class="fixed hidden z-50 inset-0 bg-gray-900 bg-opacity-60 overflow-y-auto h-full w-full px-4">

            <div class="relative top-40 mx-auto shadow-xl rounded-md bg-white max-w-md">
                <div class="flex justify-end p-2">
                    <button onclick="closeDeleteModal()" type="button"
                        class="closeModalBtnDel disabled:opacity-70 disabled:cursor-not-allowed text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center">
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd"
                                d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                                clip-rule="evenodd"></path>
                        </svg>
                    </button>
                </div>

                <div class="spinnerDel hidden pt-6 pb-10 text-center flex-spinner justify-center">
                    <svg class="animate-spin h-20 w-20 text-brand-blue" width="24" height="24" viewBox="0 0 24 24"
                        fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path opacity="0.2" fill-rule="evenodd" clip-rule="evenodd"
                            d="M12 19C15.866 19 19 15.866 19 12C19 8.13401 15.866 5 12 5C8.13401 5 5 8.13401 5 12C5 15.866 8.13401 19 12 19ZM12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22Z"
                            fill="currentColor" />
                        <path d="M2 12C2 6.47715 6.47715 2 12 2V5C8.13401 5 5 8.13401 5 12H2Z" fill="currentColor" />
                    </svg>
                </div>

                <div class="contentDel p-6 pt-0 text-center">
                    <h3 class="text-lg leading-6 font-medium text-gray-900" id="modal-title">
                        Deletar Categoria
                    </h3>
                    <div class="m-2">
                        <p class="text-base text-gray-500">
                            Tem certeza que deseja deletar a categoria <span class="font-semibold"
                                id="deleteCategoryName">Nome da Categoria</span>?
                        </p>
                    </div>
                    <div class="flex justify-end gap-2 mt-2">
                        <button onclick="closeDeleteModal()" id="cancelBtn"
                            class="text-gray-700 bg-white hover:bg-gray-100 focus:ring-4 focus:ring-cyan-200 border border-gray-200 font-medium rounded-lg text-sm w-32 text-center px-5 py-2.5"
                            data-modal-toggle="delete-user-modal">
                            Cancelar
                        </button>

                        <button onclick="deleteCategory()" type="button" id="deleteBtn"
                            class="text-white bg-pink-700 hover:bg-pink-800 focus:ring-4 focus:outline-none focus:ring-pink-300 font-medium rounded-lg text-sm w-32 text-center px-5 py-2.5">
                            <div class="mx-auto flex itens-center justify-center gap-2">
                                <span id="submitBtnText">Delete</span>
                            </div>
                        </button>
                    </div>
                </div>
            </div>

    </div>

    <script defer>


        window.openModal = (modalId) => {
            document.getElementById(modalId).style.display = "block";
            document.getElementsByTagName("body")[0].classList.add("overflow-y-hidden");
        };

        window.closeModal = (modalId) => {
            document.getElementById(modalId).style.display = "none";
            document
                .getElementsByTagName("body")[0]
                .classList.remove("overflow-y-hidden");
            resetForm();
        };

        function resetForm() {
            document.getElementById("categoryForm").action =
                "{{ route('categories.store') }}";
            document.getElementById("formMethod").value = "POST";
            document.getElementById("categoryId").value = "";
            document.getElementById("categoria").value = "";
            document.getElementById("submitBtn").textContent = "Salvar";
        }

        window.openEditModal = (category) => {
            document.getElementById(
                "categoryForm"
            ).action = `/dashboard/categories/${category.id}`;
            document.getElementById("formMethod").value = "PUT";
            document.getElementById("categoryId").value = category.id;
            document.getElementById("categoria").value = category.name;
            document.getElementById("submitBtn").textContent = "Atualizar";
            openModal("formModal");
        };

        const showSpinner = () => {
            document.querySelector(".spinner").classList.remove("hidden");
            document.querySelector(".content").classList.add("hidden");
            document.querySelector(".spinnerDel").classList.remove("hidden");
            document.querySelector(".contentDel").classList.add("hidden");

            document.querySelector(".closeModalBtn").disabled = true;
            document.querySelector(".closeModalBtnDel").disabled = true;
        };

        const submitBtn = document.getElementById("submitBtn");

        if (submitBtn) {
            submitBtn.addEventListener("click", function (event) {
                event.preventDefault();
                showSpinner();
                sendForm();
            });
        }

        const sendForm = () => {
            document.getElementById("categoryForm").submit();
        };

        document.onkeydown = function (event) {
            event = event || window.event;
            if (event.keyCode === 27) {
                closeModal("formModal");
            }
        };

        const openDeleteModal = (category) => {
            document.getElementById("deleteCategoryName").textContent = category.name;
            document.getElementById("deleteCategoryId").value = category.id;

            document.getElementById("deleteModal").classList.remove("hidden");
            document.body.classList.add("overflow-y-hidden");
        };


        const closeDeleteModal = () => {
            document.getElementById("deleteModal").classList.add("hidden");
            document.body.classList.remove("overflow-y-hidden");
        };


        const deleteCategory = () => {
            showSpinner();
            document.getElementById("deleteForm").submit();
        };


    </script>

</x-app-layout>
