<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
                Editar Post - <span class="font-normal text-sm text-gray-500">{{ $post->title }}</span>
            </h2>
            <a href="{{ route('posts') }}" wire:navigate
                class="flex items-center gap-2 text-white bg-green-600 hover:bg-green-700 focus:ring-4 focus:outline-none focus:ring-green-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center w-fit">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M10.6276 14.7219L9.21641 16.1391L2.83875 9.78892L9.18897 3.41125L10.6062 4.82242L6.82971 8.61526L17.1353 8.59304C19.3445 8.58828 21.1392 10.3753 21.144 12.5844L21.1612 20.5844L19.1612 20.5887L19.144 12.5887C19.1416 11.4841 18.2442 10.5907 17.1396 10.593L6.50391 10.616L10.6276 14.7219Z" fill="currentColor" /></svg>
                Voltar
            </a>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
                <div class="md:p-6 p-2 text-gray-900 dark:text-gray-100">

                    <div class="content md:p-6 p-2 pt-0">

                        <form method="POST" action="{{ route('post.update', $post->id) }}" id="postForm"
                            class="max-w-3xl mx-auto" enctype="multipart/form-data">
                            @csrf
                            @method('PUT')

                            <div class="mb-5">
                                <label for="title"
                                    class="block mb-2 pl-2 text-sm font-medium text-gray-900 dark:text-white">
                                    Título
                                </label>
                                <input type="text" id="title" name="title" required value="{{ $post->title }}"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-brand-blue focus:border-brand-blue block w-full p-2.5"
                                    placeholder="Título" required />
                                @error('title')
                                <p class="text-red-500 text-sm ml-2 mt-2 font-bold italic">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="mb-5">
                                <label for="capa" class="block mb-2 pl-2 text-sm font-medium text-gray-900 dark:text-white">
                                    Imagem de Capa <span class="text-gray-500 font-normal text-xs">(dimensões mínimas 1600 x 500 px - tamanho máximo 500kb - formatos: jpg, png, webp)</span>
                                </label>
                                <div class="flex flex-wrap items-center md:space-x-6 justify-center sm:justify-start">
                                    <div class="shrink-0 sm:mb-2">
                                        <img id='preview_img' class="h-20 w-52 object-cover border-solid border-2 border-gray-300" src="/img/uploads/{{ $post->capa }}" alt="Imagem Atual" />
                                    </div>
                                    <input type="file" id="capa" name="capa" onchange="loadFile(event)" class="block text-sm text-slate-500 bg-gray-100 rounded-full
                                    px-4 py-2 mt-2 md:mt-0
                                    w-full sm:w-fit
                                    file:mr-4 file:py-2 file:px-4
                                    file:rounded-full file:border-0
                                    file:text-sm file:font-semibold
                                    file:bg-brand-blue file:text-white
                                    hover:file:bg-brand-orange"/>
                                </div>
                                @error('capa')
                                    <p class="text-red-500 text-sm ml-2 mt-2 font-bold italic">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="mb-5">
                                <label for="category" class="block mb-2 pl-2 text-sm font-medium text-gray-900 dark:text-white">Categoria:</label>
                                <select id="category" name="categories_id" x-model="categories_id" required
                                    x-on:change="categories_id = $event.target.value"
                                    class="w-full bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg p-2.5">
                                    <option value="">Selecione uma categoria</option>
                                    @foreach ($categories as $categoryId => $categoryName)
                                        <!-- Defina a categoria selecionada -->
                                        <option value="{{ $categoryId }}" {{ $post->categories_id == $categoryId ? 'selected' : '' }}>
                                            {{ $categoryName }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('categories_id')
                                    <p class="text-red-500 text-sm ml-2 mt-2 font-bold italic">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="mb-7">
                                <label for="editor" class="block mb-2 pl-2 text-sm font-medium text-gray-900 dark:text-white">Descrição:</label>
                                <textarea id="editor" name="description">{{ $post->description }}</textarea>
                                @error('description')
                                    <p class="text-red-500 text-sm ml-2 mt-2 font-bold italic">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="flex justify-end gap-2">
                                <button type="submit"
                                    id="submitPost"
                                    class="disabled:cursor-not-allowed disabled:opacity-50 flex-spinner justify-center items-center text-white bg-brand-blue hover:bg-brand-blue-2 focus:ring-4 focus:outline-none focus:ring-brand-blue font-medium rounded-lg text-sm w-32 text-center px-5 py-2.5">
                                    <div class="mx-auto flex itens-center justify-center gap-2">
                                        Salvar
                                    </div>

                                    <svg class="spinnerPost hidden animate-spin h-6 w-6 text-white" width="24" height="24"
                                        viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path opacity="0.2" fill-rule="evenodd" clip-rule="evenodd"
                                            d="M12 19C15.866 19 19 15.866 19 12C19 8.13401 15.866 5 12 5C8.13401 5 5 8.13401 5 12C5 15.866 8.13401 19 12 19ZM12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22Z"
                                            fill="currentColor" />
                                        <path d="M2 12C2 6.47715 6.47715 2 12 2V5C8.13401 5 5 8.13401 5 12H2Z"
                                            fill="currentColor" />
                                    </svg>
                                </button>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>

    @if (session('success'))
    <div id="toastSuccess" class="fixed inset-x-0 top-0 flex items-end justify-right px-4 py-6 justify-end">
        <div
            class="max-w-sm w-full shadow-lg rounded px-4 py-3 relative bg-green-400 border-l-4 border-green-700 text-white">
            <div class="p-2">
                <div class="flex items-start">
                    <div class="ml-3 w-0 flex-1 pt-0.5">
                        <p class="text-sm leading-5 font-medium">
                            {{ session('success') }}
                        </p>
                    </div>
                    <div class="ml-4 flex-shrink-0 flex">
                        <button class="inline-flex text-white transition ease-in-out duration-150"
                            onclick="return this.parentNode.parentNode.parentNode.parentNode.remove()">
                            <svg class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd"
                                    d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                                    clip-rule="evenodd" />
                            </svg>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @elseif (session('error'))
    <div id="toastError" class="fixed inset-x-0 top-0 flex items-end justify-right px-4 py-6 justify-end">
        <div
            class="max-w-sm w-full shadow-lg rounded px-4 py-3 relative bg-yellow-400 border-l-4 border-yellow-700 text-white">
            <div class="p-2">
                <div class="flex items-start">
                    <div class="ml-3 w-0 flex-1 pt-0.5">
                        <p class="text-sm leading-5 font-medium">
                            {{ session('error') }}
                        </p>
                    </div>
                    <div class="ml-4 flex-shrink-0 flex">
                        <button class="inline-flex text-white transition ease-in-out duration-150"
                            onclick="return this.parentNode.parentNode.parentNode.parentNode.remove()">
                            <svg class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd"
                                    d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                                    clip-rule="evenodd" />
                            </svg>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif

    <script defer>
        var loadFile = function (event) {
            var input = event.target;
            var file = input.files[0];
            var type = file.type;

            var output = document.getElementById("preview_img");

            output.src = URL.createObjectURL(event.target.files[0]);
            output.onload = function () {
                URL.revokeObjectURL(output.src); // free memory
            };
        };


        var editor = new Jodit("#editor", {
            height: 300,
            placeholder: "Escreva aqui ...",
            language: "pt_br",
            showXPathInStatusbar: false,
            enableDragAndDropFileToEditor: true,
            imageDefaultWidth: 750,
            showTooltip: true,
            uploader: {
                insertImageAsBase64URI: true,
                imagesExtensions: ["jpg", "png", "jpeg", "gif", "svg", "webp"],
            },
            image: {
                useImageEditor: true,
            },
        });

        const submitPost = document.getElementById("submitPost");

        if (submitPost) {
            submitPost.addEventListener("click", function (event) {
                event.preventDefault();
                document.querySelector(".spinnerPost").classList.remove("hidden");
                this.disabled = true;
                sendForm();
            });
        }

        const sendForm = () => {
            document.getElementById("postForm").submit();
        };
    </script>


    </x-app-layout>
