<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    
    <link rel="shortcut icon" type="image/jpg" href="/img/favicon.png" />

    <title>{{ config('app.name', 'Laravel') }}</title>

    <link rel="stylesheet" href="/css/dash.css">
    <!-- Scripts -->
    <link rel="stylesheet" href="/css/jodit.min.css" />
    <script src="/js/jodit.min.js"></script>

    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>

<body class="font-sans antialiased">
    <div class="min-h-screen bg-gray-100 dark:bg-gray-900">
        <livewire:layout.navigation />

        <!-- Page Heading -->
        @if (isset($header))
        <header class="bg-white dark:bg-gray-800 shadow">
            <div class="max-w-7xl mx-auto py-6 px-4 sm:px-6 lg:px-8">
                {{ $header }}
            </div>
        </header>
        @endif

        <!-- Page Content -->
        <main>
            {{ $slot }}
        </main>
    </div>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            content: [
                "./vendor/laravel/framework/src/Illuminate/Pagination/resources/views/*.blade.php",
                "./storage/framework/views/*.php",
                "./resources/views/**/*.blade.php",
                "./resources/**/*.js",
                "./resources/**/*.vue",
            ],

            theme: {
                extend: {
                    colors: {
                        "brand-blue": "#02B7D5",
                        "brand-blue-2": "#0096C7",
                        "brand-orange": "#F89C43",
                        "brand-orange-2": "#F05F23",
                    },
                },
            }
        }
      </script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="/js/dash.js"></script>
</body>

</html>
