@extends('layouts.main')

@section('title', $post->title)
@section('description', $post->description)
@section('keywords', 'okea', 'asterian', 'mes software', 'software para a indústria', 'manutenção preditiva', 'sistema MES', 'gestão de ativos', 'sistema mes 4.0')

@section('content')
    <div class="container news-open">
        <div class="news-open card pt-4 mt-4">
            <h5 class="regular-gray-4">{{ $post->title }}</h5>
            <p class="regular-gray-1">{{ $post->created_at->format('d/m/Y') }}</p>
            <img src="{{ asset('img/uploads/' . $post->capa) }}" class="card-img-top" alt="{{ $post->title }}">
            <div class="card-body mt-4">
                <div id="description" class="news-desc">{!! $post->description !!}</div>
            </div>
        </div>

        {{-- <div class="container mt-5">
            <h3 class="mb-4">Últimas Notícias</h3>
            <div class="row row-cols-1 row-cols-md-3 g-4">
                @foreach($latestPosts as $latestPost)
                <div class="col">
                    <div class="news-list card h-100">
                        <img src="{{ asset('img/uploads/' . $latestPost->capa) }}" class="card-img-top" alt="{{ $latestPost->title }}">
                        <div class="card-body">
                            <p class="card-text">{{ $post->category->name }}</p>
                            <h5 class="card-title">{{ $latestPost->title }}</h5>
                            <p class="card-text">{{ $post->created_at->format('d/m/Y') }}</p>
                            <a href="{{ route('novidades.show', $latestPost->slug) }}" class="btn btn-primary">Ler mais</a>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div> --}}
    </div>

    <script>
        const paragraphs = document.querySelectorAll('#description p');
        paragraphs.forEach(paragraph => {
            paragraph.removeAttribute('style');
        });
    </script>
@endsection
