@extends('layouts.main')

@section('title', 'ÓKEA - Novidades')
@section('description', 'Torne a sua indústria mais eficiente com Asterian® e produza resultados.')
@section('keywords', 'okea', 'asterian', 'mes software', 'software para a indústria', 'manutenção preditiva', 'sistema MES', 'gestão de ativos', 'sistema mes 4.0')

@section('content')

    <section class="container mx-auto news-list p-3 p-md-4 p-lg-5">
        <div class="flex justify-content-center row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4">
            @foreach($posts as $post)
                <div class="col">
                    <div class="card">
                        <div class="p-3">
                            <img src="{{ asset('img/uploads/' . $post->capa) }}" class="card-img-top" alt="{{ $post->title }}">
                        </div>
                        <div class="card-body w-100">
                            <div class="d-flex justify-content-between regular-gray-1">
                                <p>{{ $post->created_at->format('d/m/Y') }}</p>
                                <p>{{ $post->category->name }}</p>
                            </div>
                            <div class="news-title m-3">
                                <h5 class="card-title bold-gray-1 text-center">{{ $post->title }}</h5>
                            </div>
                            <div class="w-100 d-flex justify-content-center">
                                <a href="{{ route('novidades.show', $post->slug) }}" class="btn-news d-flex align-content-center text-center">
                                    Leia mais
                                    <span class="ms-2">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 30 30">
                                            <path id="arrow" data-name="arrow"
                                                d="M65.161,28.82A15.038,15.038,0,1,1,71,30,14.945,14.945,0,0,1,65.161,28.82ZM58.728,15A12.273,12.273,0,1,0,71,2.727,12.287,12.287,0,0,0,58.728,15Zm11.308,6.419a1.364,1.364,0,0,1,0-1.929l3.126-3.126H65.545a1.363,1.363,0,1,1,0-2.727h7.617l-3.127-3.127a1.364,1.364,0,0,1,1.928-1.928l5.455,5.455.007.008.009.01.015.016.008.008.016.018,0,0a1.357,1.357,0,0,1,.234.37l0,.006.009.023,0,.012.006.017.007.018,0,.011.008.023,0,.006.008.026v0l.008.029v0l.008.03h0l.007.029v0l.006.027v.006l0,.024,0,.011,0,.02,0,.022v.008a1.361,1.361,0,0,1-.388,1.137l-5.455,5.455a1.364,1.364,0,0,1-1.928,0Z"
                                                transform="translate(-56)" fill="#fff" />
                                        </svg>
                                    </span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </section>
    {{ $posts->links() }}



@endsection
