<?php

use App\Http\Controllers\LanguageController;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\App;
use Illuminate\Http\Request;
use App\Http\Controllers\CategoriesController;
use App\Http\Controllers\ContatoController;
use App\Http\Controllers\NewsController;
use App\Http\Controllers\NovidadesController;
use Illuminate\Support\Facades\File;

Route::get('/', function () {
    $json = File::get(public_path('data/testimonials.json'));
    $depoimentos = json_decode($json, true);

    return view('welcome', compact('depoimentos'));
});

// Route::view('/', 'welcome');

Route::view('dashboard', 'dashboard.index')
    ->middleware(['auth', 'verified'])
    ->name('dashboard');


Route::view('profile', 'profile')
    ->middleware(['auth'])
    ->name('profile');

Route::get('dashboard/categorias', [CategoriesController::class, 'index'])
    ->middleware(['auth', 'verified'])
    ->name('categorias');

Route::post('dashboard/categorias', [CategoriesController::class, 'store'])->middleware(['auth'])->name('categories.store');

Route::put('/dashboard/categories/{category}', [CategoriesController::class, 'update'])->name('dashboard.categories.update');

Route::delete('/dashboard/categories/{category}', [CategoriesController::class, 'destroy'])->name('dashboard.categories.destroy');

Route::get('dashboard/posts', [NewsController::class, 'index'])
    ->middleware(['auth', 'verified'])
    ->name('posts');

Route::get('dashboard/posts/novo', [NewsController::class, 'create'])->middleware(['auth'])->name('newpost');

Route::post('dashboard/posts/novo', [NewsController::class, 'store'])->middleware(['auth'])->name('post.store');

Route::delete('/dashboard/posts/{post}', [NewsController::class, 'destroy'])->name('dashboard.posts.destroy');

Route::get('/dashboard/posts/{post}', [NewsController::class, 'edit'])->name('post.edit');

Route::put('/dashboard/posts/{post}', [NewsController::class, 'update'])->name('post.update');


require __DIR__ . '/auth.php';


Route::post('/language-switch', action: [LanguageController::class, 'languageSwitch'])->name(name: 'language.switch');

Route::get('/sobre', function () {
    return view('about');
});

Route::get('/solucoes', function () {
    return view('solutions');
});

// Rota para a listagem de novidades
Route::get('/novidades', [NovidadesController::class, 'index'])->name('novidades.index');
// Rota para exibir um post específico
Route::get('/novidades/{slug}', [NovidadesController::class, 'show'])->name('novidades.show');

Route::get('/contato', function () {
    return view('contact');
});

Route::get('/privacidade', function () {
    return view('privacidade');
});

Route::post(uri: '/contato', action: [ContatoController::class, 'store'])->name('contato.store');

Route::get('/ef1.pdf', function () {
    return redirect('https://okea.com.br/arquivos/ef1.pdf');
});

