<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
        
        <link rel="shortcut icon" type="image/jpg" href="/img/favicon.png" />

        <title><?php echo e(config('app.name', 'Laravel')); ?></title>

        <!-- Scripts -->
        <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    </head>
    <body class="font-sans text-gray-900 antialiased">
        <div class="min-h-screen flex flex-col sm:justify-center items-center pt-6 sm:pt-0 bg-gray-100 dark:bg-gray-900">
            <div>
                <a href="/" wire:navigate>
                    
                    <img src="/img/okea-logo-icon.svg" alt="" class="w-20">
                </a>
            </div>

            <div class="w-full sm:max-w-md mt-6 px-6 py-4 bg-white dark:bg-gray-800 shadow-md overflow-hidden sm:rounded-lg">
                <?php echo e($slot); ?>

            </div>
        </div>

        <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            content: [
                "./vendor/laravel/framework/src/Illuminate/Pagination/resources/views/*.blade.php",
                "./storage/framework/views/*.php",
                "./resources/views/**/*.blade.php",
                "./resources/**/*.js",
                "./resources/**/*.vue",
            ],

            theme: {
                extend: {
                    colors: {
                        "brand-blue": "#02B7D5",
                        "brand-blue-2": "#0096C7",
                        "brand-orange": "#F89C43",
                        "brand-orange-2": "#F05F23",
                    },
                },
            }
        }
      </script>
    </body>
</html>
<?php /**PATH /home/okea/public_html/resources/views/layouts/guest.blade.php ENDPATH**/ ?>